/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen.features;

import com.mojang.serialization.Codec;
import com.tristankechlo.explorations.worldgen.features.config.ScarecrowFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ScarecrowFeature
extends Feature<ScarecrowFeatureConfig> {
    public ScarecrowFeature(Codec<ScarecrowFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ScarecrowFeatureConfig> context) {
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        Direction facingHead = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        Direction facingArmLeft = facingHead.getClockWise(Direction.Axis.Y);
        Direction facingArmRight = facingHead.getCounterClockWise(Direction.Axis.Y);
        BlockPos posLeg = context.origin();
        BlockPos posBody = posLeg.above(1);
        BlockPos posHead = posLeg.above(2);
        BlockPos posLeftArm = posLeg.above().relative(facingArmLeft);
        BlockPos posRightArm = posLeg.above().relative(facingArmRight);
        if (!ScarecrowFeature.canBePlaced(level, ((ScarecrowFeatureConfig)context.config()).forcePlace(), posLeg, posBody, posHead, posLeftArm, posRightArm)) {
            return false;
        }
        BlockState stateHead = ScarecrowFeature.createHead(((ScarecrowFeatureConfig)context.config()).head().getState(random, posHead), facingHead);
        BlockState stateBody = ((ScarecrowFeatureConfig)context.config()).body().getState(random, posBody);
        BlockState stateLegs = ((ScarecrowFeatureConfig)context.config()).legs().getState(random, posLeg);
        BlockState stateArmLeft = ScarecrowFeature.createArm(((ScarecrowFeatureConfig)context.config()).arms().getState(random, posLeftArm), facingArmLeft);
        BlockState stateArmRight = ScarecrowFeature.createArm(((ScarecrowFeatureConfig)context.config()).arms().getState(random, posRightArm), facingArmRight);
        level.setBlock(posLeg, stateLegs, 3);
        level.setBlock(posBody, stateBody, 3);
        level.setBlock(posLeftArm, stateArmLeft, 3);
        level.setBlock(posRightArm, stateArmRight, 3);
        level.setBlock(posHead, stateHead, 3);
        return true;
    }

    private static BlockState createArm(BlockState armState, Direction facing) {
        if (facing == Direction.NORTH && armState.hasProperty((Property)BlockStateProperties.SOUTH)) {
            armState = (BlockState)armState.setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.TRUE);
        } else if (facing == Direction.EAST && armState.hasProperty((Property)BlockStateProperties.WEST)) {
            armState = (BlockState)armState.setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.TRUE);
        } else if (facing == Direction.SOUTH && armState.hasProperty((Property)BlockStateProperties.NORTH)) {
            armState = (BlockState)armState.setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.TRUE);
        } else if (facing == Direction.WEST && armState.hasProperty((Property)BlockStateProperties.EAST)) {
            armState = (BlockState)armState.setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.TRUE);
        }
        return armState;
    }

    private static BlockState createHead(BlockState headState, Direction facing) {
        if (headState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            headState = (BlockState)headState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
        } else if (headState.hasProperty((Property)BlockStateProperties.FACING)) {
            headState = (BlockState)headState.setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
        }
        return headState;
    }

    private static boolean canBePlaced(WorldGenLevel level, boolean forceReplace, BlockPos ... positions) {
        for (BlockPos pos : positions) {
            boolean replaceable;
            if (level.isOutsideBuildHeight(pos) || level.getBlockState(pos).is(BlockTags.FEATURES_CANNOT_REPLACE)) {
                return false;
            }
            BlockState state = level.getBlockState(pos);
            boolean bl = replaceable = forceReplace || level.isEmptyBlock(pos) || state.getFluidState().isEmpty() || state.canBeReplaced();
            if (replaceable) continue;
            return false;
        }
        return true;
    }
}

