/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen;

import com.mojang.datafixers.util.Pair;
import com.tristankechlo.explorations.Explorations;
import com.tristankechlo.explorations.config.ExplorationsConfig;
import com.tristankechlo.explorations.config.types.VillageType;
import com.tristankechlo.explorations.mixin.StructureTemplatePoolAccessor;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public final class WorldGenHelper {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"empty"));

    public static void addStatuesToVillages(MinecraftServer server) {
        Registry templatePoolReg = (Registry)server.registryAccess().registry(Registries.TEMPLATE_POOL).orElseThrow();
        Registry processorListReg = (Registry)server.registryAccess().registry(Registries.PROCESSOR_LIST).orElseThrow();
        ExplorationsConfig.get().statues().forEach((type, list) -> list.forEach(e -> WorldGenHelper.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolReg, (Registry<StructureProcessorList>)processorListReg, type, e.nbtLoc(), e.weight())));
        Explorations.LOGGER.info("Added statues to vanilla villages");
    }

    private static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolReg, Registry<StructureProcessorList> processorListReg, VillageType type, String nbtPieceRL, int weight) {
        Holder.Reference emptyProcessorList = processorListReg.getHolderOrThrow(EMPTY_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolReg.get(type.getLocation());
        if (!(pool instanceof StructureTemplatePoolAccessor)) {
            return;
        }
        StructureTemplatePoolAccessor poolAccessor = (StructureTemplatePoolAccessor)pool;
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.legacy((String)nbtPieceRL, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            poolAccessor.getTemplates().add((Object)piece);
        }
        ArrayList<Pair<StructurePoolElement, Integer>> listOfPieceEntries = new ArrayList<Pair<StructurePoolElement, Integer>>();
        listOfPieceEntries.addAll(poolAccessor.getRawTemplates());
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        poolAccessor.setRawTemplates(listOfPieceEntries);
    }
}

