/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations;

import com.google.auto.service.AutoService;
import com.tristankechlo.explorations.registration.RegistrationProvider;
import com.tristankechlo.explorations.registration.RegistryObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@AutoService(value={RegistrationProvider.Factory.class})
public final class NeoforgeRegistrationFactory
implements RegistrationProvider.Factory {
    @Override
    public <T> RegistrationProvider<T> create(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        Optional containerOpt = ModList.get().getModContainerById(modId);
        if (containerOpt.isEmpty()) {
            throw new NullPointerException("Cannot find mod container for id " + modId);
        }
        ModContainer cont = (ModContainer)containerOpt.get();
        if (cont instanceof FMLModContainer) {
            FMLModContainer fmlModContainer = (FMLModContainer)cont;
            DeferredRegister register = DeferredRegister.create(resourceKey, (String)modId);
            register.register(fmlModContainer.getEventBus());
            return new Provider(modId, register);
        }
        throw new ClassCastException("The container of the mod " + modId + " is not a FML one!");
    }

    private static class Provider<T>
    implements RegistrationProvider<T> {
        private final String modId;
        private final DeferredRegister<T> registry;
        private final Set<RegistryObject<T>> entries = new HashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(String modId, DeferredRegister<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        @Override
        public String getModId() {
            return this.modId;
        }

        @Override
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            final ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name);
            final DeferredHolder obj = this.registry.register(name, supplier);
            RegistryObject ro = new RegistryObject<I>(){
                final ResourceKey<I> key;
                {
                    this.key = ResourceKey.create((ResourceKey)registry.getRegistryKey(), (ResourceLocation)rl);
                }

                @Override
                public ResourceKey<I> getResourceKey() {
                    return this.key;
                }

                @Override
                public ResourceLocation getId() {
                    return obj.getId();
                }

                @Override
                public I get() {
                    return obj.get();
                }

                @Override
                public Holder<I> asHolder() {
                    return Holder.direct((Object)obj.get());
                }
            };
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Set<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }
    }
}

