/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu;

import io.wispforest.accessories.menu.SlotAccessContainer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public interface SaddleableContainer
extends Container {
    @Nullable
    public static Container of(LivingEntity living) {
        if (living instanceof AbstractHorse) {
            AbstractHorse abstractHorse = (AbstractHorse)living;
            return SaddleableContainer.ofHorse(abstractHorse);
        }
        if (living instanceof Saddleable) {
            Saddleable saddleable = (Saddleable)living;
            return SaddleableContainer.ofSaddleable(saddleable);
        }
        return null;
    }

    public static Container ofHorse(AbstractHorse abstractHorse) {
        return new SlotAccessContainer(abstractHorse.getSlot(400));
    }

    public static Container ofSaddleable(Saddleable saddleable) {
        return new SlotAccessContainer(SlotAccess.of(() -> saddleable.isSaddled() ? Items.SADDLE.getDefaultInstance() : ItemStack.EMPTY, stack -> saddleable.equipSaddle(stack, SoundSource.NEUTRAL)));
    }

    public Saddleable saddleable();

    public ItemStack getSaddle();

    public ItemStack removeSaddle();

    default public int getContainerSize() {
        return 1;
    }

    default public boolean isEmpty() {
        return this.getItem(0).isEmpty();
    }

    default public ItemStack getItem(int slot) {
        return this.getSaddle();
    }

    default public ItemStack removeItem(int slot, int amount) {
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        return this.removeSaddle();
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        return this.removeSaddle();
    }

    default public void setItem(int slot, ItemStack stack) {
        this.saddleable().equipSaddle(stack, SoundSource.NEUTRAL);
    }

    default public void setChanged() {
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    default public void clearContent() {
    }
}

