/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.api.client.EmptyRenderer;
import io.wispforest.accessories.api.client.Side;
import io.wispforest.accessories.api.client.rendering.ModelTransformUtils;
import io.wispforest.accessories.api.slot.SlotReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface AccessoryRenderer {
    public <M extends LivingEntity> void render(ItemStack var1, SlotReference var2, PoseStack var3, EntityModel<M> var4, MultiBufferSource var5, int var6, float var7, float var8, float var9, float var10, float var11, float var12);

    default public boolean shouldRender(boolean isRendering) {
        return isRendering;
    }

    default public boolean shouldRenderInFirstPerson(HumanoidArm arm, ItemStack stack, SlotReference reference) {
        return false;
    }

    default public <M extends LivingEntity> void renderOnFirstPerson(HumanoidArm arm, ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<M> model, MultiBufferSource multiBufferSource, int light) {
        if (!this.shouldRenderInFirstPerson(arm, stack, reference)) {
            return;
        }
        this.render(stack, reference, matrices, model, multiBufferSource, light, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    @ApiStatus.NonExtendable
    default public boolean isEmpty() {
        return this instanceof EmptyRenderer;
    }

    @Deprecated(forRemoval=true)
    public static void followBodyRotations(LivingEntity entity, HumanoidModel<LivingEntity> model) {
        LivingEntityRenderer renderer;
        EntityModel entityModel;
        EntityRenderer render = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entity);
        if (render instanceof LivingEntityRenderer && (entityModel = (renderer = (LivingEntityRenderer)render).getModel()) instanceof HumanoidModel) {
            HumanoidModel entityModel2 = (HumanoidModel)entityModel;
            entityModel2.copyPropertiesTo(model);
        }
    }

    @Deprecated
    public static void translateToFace(PoseStack poseStack, HumanoidModel<? extends LivingEntity> model, LivingEntity entity) {
        AccessoryRenderer.transformToFace(poseStack, model.head, Side.FRONT);
    }

    @Deprecated(forRemoval=true)
    public static void translateToChest(PoseStack poseStack, HumanoidModel<? extends LivingEntity> model, LivingEntity livingEntity) {
        AccessoryRenderer.transformToModelPart(poseStack, model.body);
    }

    @Deprecated(forRemoval=true)
    public static void translateToRightArm(PoseStack poseStack, HumanoidModel<? extends LivingEntity> model, LivingEntity player) {
        AccessoryRenderer.transformToFace(poseStack, model.rightArm, Side.BOTTOM);
    }

    @Deprecated(forRemoval=true)
    public static void translateToLeftArm(PoseStack poseStack, HumanoidModel<? extends LivingEntity> model, LivingEntity player) {
        AccessoryRenderer.transformToFace(poseStack, model.leftArm, Side.BOTTOM);
    }

    @Deprecated(forRemoval=true)
    public static void translateToRightLeg(PoseStack poseStack, HumanoidModel<? extends LivingEntity> model, LivingEntity player) {
        AccessoryRenderer.transformToFace(poseStack, model.rightLeg, Side.BOTTOM);
    }

    @Deprecated(forRemoval=true)
    public static void translateToLeftLeg(PoseStack poseStack, HumanoidModel<? extends LivingEntity> model, LivingEntity player) {
        AccessoryRenderer.transformToFace(poseStack, model.leftLeg, Side.BOTTOM);
    }

    public static void transformToFace(PoseStack poseStack, ModelPart part, Side side) {
        ModelTransformUtils.transformToFace(poseStack, part, side);
    }

    public static void transformToModelPart(PoseStack poseStack, ModelPart part) {
        ModelTransformUtils.transformToModelPart(poseStack, part, 0, 0, 0);
    }

    public static void transformToModelPart(PoseStack poseStack, ModelPart part, @Nullable Number xPercent, @Nullable Number yPercent, @Nullable Number zPercent) {
        ModelTransformUtils.transformToModelPart(poseStack, part, xPercent, yPercent, zPercent);
    }
}

