/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.operation.param;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypeReference;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;
import org.objectweb.asm.tree.TypeAnnotationNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.analysis.locals.LVTSnapshot;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.ModifyArgsOffsetTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.ParamTransformationUtil;
import org.sinytra.adapter.patch.transformer.operation.param.ParameterTransformer;

public record InjectParameterTransform(int index, Type type, boolean upgradeWrapOperation) implements ParameterTransformer
{
    public InjectParameterTransform(int index, Type type) {
        this(index, type, true);
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context, List<Type> parameters, int offset) {
        boolean isNonStatic = (methodNode.access & 8) == 0;
        int index = this.index + offset;
        if (index >= parameters.size() + 1) {
            return Patch.Result.PASS;
        }
        AnnotationHandle annotation = methodContext.methodAnnotation();
        if (annotation.matchesDesc("Lorg/spongepowered/asm/mixin/injection/ModifyVariable;")) {
            annotation.getValue("index").ifPresent(indexHandle -> {
                int indexValue = (Integer)indexHandle.get();
                if (indexValue >= index) {
                    indexHandle.set(indexValue + 1);
                }
            });
            return Patch.Result.APPLY;
        }
        if (annotation.matchesDesc("Lorg/spongepowered/asm/mixin/injection/ModifyArgs;")) {
            ModifyArgsOffsetTransformer.modify(methodNode, List.of(Pair.of((Object)this.index, (Object)this.type)));
            return Patch.Result.APPLY;
        }
        LocalVariableNode self = methodNode.localVariables.stream().filter(lvn -> lvn.index == 0).findFirst().orElseThrow();
        int lvtIndex = ParamTransformationUtil.calculateLVTIndex(parameters, isNonStatic, index);
        LVTSnapshot.with(methodNode, () -> {
            ParameterNode newParameter = new ParameterNode("adapter_injected_" + index, 4096);
            parameters.add(index, this.type);
            methodNode.parameters.add(index, newParameter);
            InjectParameterTransform.offsetParameters(methodNode, index);
            methodNode.localVariables.add(index + (isNonStatic ? 1 : 0), new LocalVariableNode(newParameter.name, this.type.getDescriptor(), null, self.start, self.end, lvtIndex));
        });
        if (this.upgradeWrapOperation) {
            ParamTransformationUtil.extractWrapOperation(methodContext, methodNode, parameters, wrapOpModification -> wrapOpModification.insertParameter(index, nodes -> nodes.add((AbstractInsnNode)new VarInsnNode(25, lvtIndex))));
        }
        return Patch.Result.APPLY;
    }

    public static void offsetParameters(MethodNode methodNode, int paramIndex) {
        ArrayList<List> annotations;
        if (methodNode.invisibleParameterAnnotations != null && paramIndex < (annotations = new ArrayList<List>(Arrays.asList(methodNode.invisibleParameterAnnotations))).size()) {
            annotations.add(paramIndex, null);
            methodNode.invisibleParameterAnnotations = (List[])annotations.toArray(List[]::new);
            methodNode.invisibleAnnotableParameterCount = annotations.size();
        }
        if (methodNode.invisibleTypeAnnotations != null) {
            List invisibleTypeAnnotations = methodNode.invisibleTypeAnnotations;
            for (int j = 0; j < invisibleTypeAnnotations.size(); ++j) {
                TypeAnnotationNode typeAnnotation = (TypeAnnotationNode)invisibleTypeAnnotations.get(j);
                TypeReference ref = new TypeReference(typeAnnotation.typeRef);
                int typeIndex = ref.getFormalParameterIndex();
                if (ref.getSort() != 22 || typeIndex < paramIndex) continue;
                invisibleTypeAnnotations.set(j, new TypeAnnotationNode(TypeReference.newFormalParameterReference((int)(typeIndex + 1)).getValue(), typeAnnotation.typePath, typeAnnotation.desc));
            }
        }
    }
}

