/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.loader.ModContainer;
import net.fabricmc.loader.api.metadata.ModOrigin;
import net.fabricmc.loader.impl.FMLModMetadata;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.discovery.BuiltinMetadataWrapper;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import net.fabricmc.loader.impl.metadata.ModOriginImpl;
import net.neoforged.neoforgespi.language.IModInfo;

public class ModContainerImpl
extends ModContainer {
    private final IModInfo modInfo;
    private final LoaderModMetadata metadata;
    private final ModOrigin origin;
    private final Collection<String> childModIds;

    public ModContainerImpl(IModInfo modInfo) {
        this(modInfo, Optional.ofNullable((LoaderModMetadata)modInfo.getOwningFile().getFileProperties().get("metadata")).orElseGet(() -> new BuiltinMetadataWrapper(new FMLModMetadata(modInfo))));
    }

    public ModContainerImpl(IModInfo modInfo, LoaderModMetadata metadata) {
        this.modInfo = modInfo;
        this.metadata = metadata;
        this.origin = new ModOriginImpl(List.of(this.modInfo.getOwningFile().getFile().getFilePath()));
        this.childModIds = modInfo.getOwningFile().getMods().stream().filter(other -> other != modInfo).map(IModInfo::getDisplayName).collect(Collectors.toSet());
    }

    @Override
    public LoaderModMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public ModOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public List<Path> getCodeSourcePaths() {
        return this.getRootPaths();
    }

    @Override
    public Path getRootPath() {
        return this.modInfo.getOwningFile().getFile().findResource(new String[]{"/"});
    }

    @Override
    public List<Path> getRootPaths() {
        return List.of(this.getRootPath());
    }

    @Override
    public Path getPath(String file) {
        return this.modInfo.getOwningFile().getFile().findResource(new String[]{file});
    }

    @Override
    public Optional<net.fabricmc.loader.api.ModContainer> getContainingMod() {
        return Optional.empty();
    }

    @Override
    public Collection<net.fabricmc.loader.api.ModContainer> getContainedMods() {
        if (this.childModIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<net.fabricmc.loader.api.ModContainer> ret = new ArrayList<net.fabricmc.loader.api.ModContainer>(this.childModIds.size());
        for (String id : this.childModIds) {
            FabricLoaderImpl.INSTANCE.getModContainer(id).ifPresent(ret::add);
        }
        return ret;
    }

    @Override
    @Deprecated
    public LoaderModMetadata getInfo() {
        return this.getMetadata();
    }

    public String toString() {
        return String.format("%s %s", this.modInfo.getModId(), this.modInfo.getVersion());
    }
}

