/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.trinkets.wrapper;

import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketEnums;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories_compat.trinkets.wrapper.TrinketsWrappingUtils;
import io.wispforest.accessories_compat.trinkets.wrapper.WrappedTrinketInventory;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public record TrinketFromAccessory(Accessory accessory) implements Trinket
{
    public void tick(ItemStack stack, dev.emi.trinkets.api.SlotReference ref, LivingEntity entity) {
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        SlotReference reference = SlotReference.of((LivingEntity)entity, (String)slotName, (int)ref.index());
        this.accessory.tick(stack, reference);
    }

    public void onEquip(ItemStack stack, dev.emi.trinkets.api.SlotReference ref, LivingEntity entity) {
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        SlotReference reference = SlotReference.of((LivingEntity)entity, (String)slotName, (int)ref.index());
        this.accessory.onEquip(stack, reference);
    }

    public void onUnequip(ItemStack stack, dev.emi.trinkets.api.SlotReference ref, LivingEntity entity) {
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        SlotReference reference = SlotReference.of((LivingEntity)entity, (String)slotName, (int)ref.index());
        this.accessory.onUnequip(stack, reference);
    }

    public boolean canEquip(ItemStack stack, dev.emi.trinkets.api.SlotReference ref, LivingEntity entity) {
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        SlotReference reference = SlotReference.of((LivingEntity)entity, (String)slotName, (int)ref.index());
        return this.accessory.canEquip(stack, reference);
    }

    public boolean canUnequip(ItemStack stack, dev.emi.trinkets.api.SlotReference ref, LivingEntity entity) {
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        SlotReference reference = SlotReference.of((LivingEntity)entity, (String)slotName, (int)ref.index());
        return this.accessory.canUnequip(stack, reference);
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getModifiers(ItemStack stack, dev.emi.trinkets.api.SlotReference ref, LivingEntity entity, ResourceLocation id) {
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        SlotReference reference = SlotReference.of((LivingEntity)entity, (String)slotName, (int)ref.index());
        AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(reference);
        this.accessory.getDynamicModifiers(stack, reference, builder);
        return builder.getAttributeModifiers(true);
    }

    public TrinketEnums.DropRule getDropRule(ItemStack stack, dev.emi.trinkets.api.SlotReference ref, LivingEntity entity) {
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        SlotReference reference = SlotReference.of((LivingEntity)entity, (String)slotName, (int)ref.index());
        DamageSource damageSource = entity.getLastDamageSource();
        if (damageSource == null) {
            damageSource = entity.level().damageSources().generic();
        }
        return TrinketsWrappingUtils.convertDropRule(this.accessory.getDropRule(stack, reference, damageSource));
    }

    public void onBreak(ItemStack stack, dev.emi.trinkets.api.SlotReference ref, LivingEntity entity) {
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        SlotReference reference = SlotReference.of((LivingEntity)entity, (String)slotName, (int)ref.index());
        this.accessory.onBreak(stack, reference);
    }

    public boolean canEquipFromUse(ItemStack stack, LivingEntity entity) {
        return this.accessory.canEquipFromUse(stack);
    }

    public Holder<SoundEvent> getEquipSound(ItemStack stack, dev.emi.trinkets.api.SlotReference ref, LivingEntity entity) {
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        SlotReference reference = SlotReference.of((LivingEntity)entity, (String)slotName, (int)ref.index());
        SoundEventData data = this.accessory.getEquipSound(stack, reference);
        if (data == null) {
            return null;
        }
        return data.event();
    }
}

