/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios.wrapper;

import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories_compat.curios.mixin.accessories.AccessoriesContainerImplAccessor;
import io.wispforest.accessories_compat.curios.wrapper.CuriosConversionUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public record AccessoriesBasedStackHandler(AccessoriesContainerImpl container) implements ICurioStacksHandler
{
    public AccessoriesBasedStackHandler(AccessoriesContainer container) {
        this(AccessoriesBasedStackHandler.validate(container));
    }

    private static AccessoriesContainerImpl validate(AccessoriesContainer container) {
        if (!(container instanceof AccessoriesContainerImpl)) {
            throw new IllegalStateException("The given instance of AccessoriesContainer was found not to be of AccessoriesContainerImpl");
        }
        AccessoriesContainerImpl container1 = (AccessoriesContainerImpl)container;
        return container1;
    }

    public IDynamicStackHandler getStacks() {
        return new HandlerImpl((AccessoriesContainer)this.container, false);
    }

    public IDynamicStackHandler getCosmeticStacks() {
        return new HandlerImpl((AccessoriesContainer)this.container, true);
    }

    public NonNullList<Boolean> getRenders() {
        return NonNullList.of((Object)Boolean.TRUE, (Object[])((Boolean[])this.container.renderOptions().toArray(Boolean[]::new)));
    }

    public int getSlots() {
        return this.container.getSize();
    }

    public boolean isVisible() {
        return true;
    }

    public boolean hasCosmetic() {
        return true;
    }

    public CompoundTag serializeNBT() {
        ListTag list;
        RegistryAccess registryAccess = this.container.capability().entity().registryAccess();
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.putInt("SavedBaseSize", this.container.getBaseSize().intValue());
        compoundNBT.put("Stacks", (Tag)this.getStacks().serializeNBT((HolderLookup.Provider)registryAccess));
        compoundNBT.put("Cosmetics", (Tag)this.getCosmeticStacks().serializeNBT((HolderLookup.Provider)registryAccess));
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.getRenders().size(); ++i) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("Slot", i);
            tag.putBoolean("Render", ((Boolean)this.getRenders().get(i)).booleanValue());
            nbtTagList.add((Object)tag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Renders", (Tag)nbtTagList);
        nbt.putInt("Size", this.getRenders().size());
        compoundNBT.put("Renders", (Tag)nbt);
        compoundNBT.putBoolean("HasCosmetic", true);
        compoundNBT.putBoolean("Visible", true);
        compoundNBT.putBoolean("RenderToggle", true);
        compoundNBT.putString("DropRule", CuriosConversionUtils.dropRuleConvertToC(this.container.slotType().dropRule()).toString());
        AccessoriesContainerImplAccessor accessor = (AccessoriesContainerImplAccessor)this.container;
        if (!accessor.persistentModifiers().isEmpty()) {
            list = new ListTag();
            for (AttributeModifier attributeModifier : accessor.persistentModifiers()) {
                list.add((Object)attributeModifier.save());
            }
            compoundNBT.put("PersistentModifiers", (Tag)list);
        }
        if (!accessor.modifiers().isEmpty()) {
            list = new ListTag();
            accessor.modifiers().forEach((uuid, modifier) -> {
                if (!accessor.persistentModifiers().contains(modifier)) {
                    list.add((Object)modifier.save());
                }
            });
            compoundNBT.put("CachedModifiers", (Tag)list);
        }
        return compoundNBT;
    }

    public void deserializeNBT(CompoundTag nbt) {
        RegistryAccess registryAccess = this.container.capability().entity().registryAccess();
        if (nbt.contains("PersistentModifiers", 9)) {
            ListTag list = nbt.getList("PersistentModifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                AttributeModifier attributeModifier = AttributeModifier.load((CompoundTag)list.getCompound(i));
                if (attributeModifier == null) continue;
                this.addPermanentModifier(attributeModifier);
            }
        }
        AccessoriesContainerImplAccessor accessor = (AccessoriesContainerImplAccessor)this.container;
        if (nbt.contains("CachedModifiers", 9)) {
            ListTag list = nbt.getList("CachedModifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                AttributeModifier attributeModifier = AttributeModifier.load((CompoundTag)list.getCompound(i));
                if (attributeModifier == null) continue;
                accessor.cachedModifiers().add(attributeModifier);
                this.addTransientModifier(attributeModifier);
            }
        }
        if (nbt.contains("Renders")) {
            CompoundTag tag = nbt.getCompound("Renders");
            List renderHandler = this.container().renderOptions();
            ListTag tagList = tag.getList("Renders", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag tags = tagList.getCompound(i);
                int slot = tags.getInt("Slot");
                if (slot < 0 || slot >= renderHandler.size()) continue;
                renderHandler.set(slot, tags.getBoolean("Render"));
            }
        }
        if (nbt.contains("Stacks")) {
            this.getStacks().deserializeNBT((HolderLookup.Provider)registryAccess, nbt.getCompound("Stacks"));
        }
        if (nbt.contains("Cosmetics")) {
            this.getCosmeticStacks().deserializeNBT((HolderLookup.Provider)registryAccess, nbt.getCompound("Cosmetics"));
        }
        this.update();
    }

    public String getIdentifier() {
        return CuriosConversionUtils.slotConvertToC(this.container.getSlotName());
    }

    public Map<ResourceLocation, AttributeModifier> getModifiers() {
        return this.container.getModifiers();
    }

    public Set<AttributeModifier> getPermanentModifiers() {
        return Set.of();
    }

    public Set<AttributeModifier> getCachedModifiers() {
        return this.container.getCachedModifiers();
    }

    public Collection<AttributeModifier> getModifiersByOperation(AttributeModifier.Operation operation) {
        return this.container.getModifiersForOperation(operation);
    }

    public void addTransientModifier(AttributeModifier modifier) {
        this.container.addTransientModifier(modifier);
    }

    public void addPermanentModifier(AttributeModifier modifier) {
        this.container.addPersistentModifier(modifier);
    }

    public void removeModifier(ResourceLocation id) {
        this.container.removeModifier(id);
    }

    public void clearModifiers() {
        this.container.clearModifiers();
    }

    public void clearCachedModifiers() {
        this.container.clearCachedModifiers();
    }

    public void copyModifiers(ICurioStacksHandler other) {
    }

    public void update() {
        this.container.update();
    }

    public CompoundTag getSyncTag() {
        return null;
    }

    public void applySyncTag(CompoundTag tag) {
    }

    public int getSizeShift() {
        return 0;
    }

    public void grow(int amount) {
    }

    public void shrink(int amount) {
    }

    public static class HandlerImpl
    implements IDynamicStackHandler {
        public final AccessoriesContainer container;
        public final ExpandedSimpleContainer accessories;
        public final boolean isCosmetic;
        public final InvWrapper wrapper;

        public HandlerImpl(AccessoriesContainer container, boolean isCosmetic) {
            this.container = container;
            this.accessories = isCosmetic ? container.getCosmeticAccessories() : container.getAccessories();
            this.isCosmetic = isCosmetic;
            this.wrapper = new InvWrapper((Container)this.accessories);
        }

        public void setPreviousStackInSlot(int slot, @NotNull ItemStack stack) {
            this.accessories.setPreviousItem(slot, stack);
        }

        public ItemStack getPreviousStackInSlot(int slot) {
            return this.accessories.getPreviousItem(slot);
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            ItemStackHandler dummyHandler = new ItemStackHandler(this.accessories.getItems());
            return dummyHandler.serializeNBT(provider);
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            ListTag tagList = nbt.getList("Items", 10);
            this.accessories.fromTag(tagList, provider);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            this.wrapper.setStackInSlot(slot, stack);
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapper.getStackInSlot(slot);
        }

        public ItemStack insertItem(int i, ItemStack arg, boolean bl) {
            return this.wrapper.insertItem(i, arg, bl);
        }

        public ItemStack extractItem(int i, int j, boolean bl) {
            return this.wrapper.extractItem(i, j, bl);
        }

        public int getSlotLimit(int i) {
            return this.wrapper.getSlotLimit(i);
        }

        public boolean isItemValid(int i, ItemStack arg) {
            return this.wrapper.isItemValid(i, arg);
        }

        public int getSlots() {
            return this.wrapper.getSlots();
        }

        public void grow(int amount) {
        }

        public void shrink(int amount) {
        }
    }
}

