/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.features;

import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.blocks.vegetation.GlowingVinesPlantBlock;
import com.kyanite.deeperdarker.world.features.config.VineFeatureConfiguration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class VineFeature
extends Feature<VineFeatureConfiguration> {
    public VineFeature(Codec<VineFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<VineFeatureConfiguration> context) {
        BlockState state;
        BlockPos origin;
        WorldGenLevel level = context.level();
        if (level.isEmptyBlock(origin = context.origin()) && (state = level.getBlockState(origin.above())).is(((VineFeatureConfiguration)context.config()).tag())) {
            this.placeVines(context, (LevelAccessor)level, context.random(), origin);
            return true;
        }
        return false;
    }

    private void placeVines(FeaturePlaceContext<VineFeatureConfiguration> context, LevelAccessor level, RandomSource random, BlockPos pos) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 100; ++i) {
            BlockState state;
            blockPos.setWithOffset((Vec3i)pos, random.nextInt(8) - random.nextInt(8), random.nextInt(2) - random.nextInt(7), random.nextInt(8) - random.nextInt(8));
            if (!level.isEmptyBlock((BlockPos)blockPos) || !(state = level.getBlockState(blockPos.above())).is(((VineFeatureConfiguration)context.config()).tag())) continue;
            int length = ((VineFeatureConfiguration)context.config()).height().sample(random);
            if (random.nextFloat() < ((VineFeatureConfiguration)context.config()).doubleChance()) {
                length *= 2;
            }
            if (random.nextFloat() < ((VineFeatureConfiguration)context.config()).reducedChance()) {
                length = 1;
            }
            this.placeVinesColumn(context, level, random, blockPos, length);
        }
    }

    private void placeVinesColumn(FeaturePlaceContext<VineFeatureConfiguration> context, LevelAccessor level, RandomSource random, BlockPos.MutableBlockPos pos, int length) {
        for (int i = 0; i <= length; ++i) {
            if (level.isEmptyBlock((BlockPos)pos) && !(level.getBlockState((BlockPos)pos).getBlock() instanceof LeavesBlock)) {
                if (i == length || !level.isEmptyBlock(pos.below())) {
                    level.setBlock((BlockPos)pos, (BlockState)((VineFeatureConfiguration)context.config()).vine().setValue((Property)GrowingPlantHeadBlock.AGE, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)random, (int)17, (int)25))), 3);
                    break;
                }
                BlockState plant = ((VineFeatureConfiguration)context.config()).plant();
                if (plant.is((Block)DDBlocks.GLOWING_VINES_PLANT.get()) && random.nextFloat() < 0.25f) {
                    plant = (BlockState)plant.setValue((Property)GlowingVinesPlantBlock.BERRIES, (Comparable)Boolean.valueOf(true));
                }
                level.setBlock((BlockPos)pos, plant, 3);
            }
            pos.move(Direction.DOWN);
        }
    }
}

