/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.neoforge;

import dev.djefrey.colorwheel.ClrwlXplat;
import dev.djefrey.colorwheel.Version;
import dev.djefrey.colorwheel.neoforge.ClrwlNeoForge;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;

public class ClrwlNeoForgeXplat
implements ClrwlXplat {
    private final Pattern VERSION_REGEX = Pattern.compile("(\\d+).(\\d+).(\\d+).*");
    private Boolean hasFlywheel = null;

    @Override
    public String getFormattedVersion() {
        String version = LoadingModList.get().getModFileById("colorwheel").versionString();
        Matcher matcher = this.VERSION_REGEX.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalStateException("Could not parse Colorwheel mod version");
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        return "%d%02d%02d".formatted(major, minor, patch);
    }

    @Override
    public boolean doesHaveFlywheel() {
        if (this.hasFlywheel == null) {
            this.hasFlywheel = ClrwlNeoForge.hasFlywheel();
        }
        return this.hasFlywheel;
    }

    @Override
    public Version getFlywheelVersion() {
        ModFileInfo modInfo = LoadingModList.get().getModFileById("flywheel");
        if (modInfo == null) {
            return null;
        }
        Matcher matcher = this.VERSION_REGEX.matcher(modInfo.versionString());
        if (!matcher.matches()) {
            throw new IllegalStateException("Could not parse Flywheel mod version");
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        return new Version(major, minor, patch);
    }
}

