/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.tags;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class EitherTag<L, R> {
    public final TagKey<L> leftTag;
    public final TagKey<R> rightTag;
    private final ResourceKey<Registry<L>> leftRegistry;
    private final ResourceKey<Registry<R>> rightRegistry;

    public EitherTag(ResourceKey<Registry<L>> leftRegistry, ResourceKey<Registry<R>> rightRegistry, ResourceLocation name) {
        this.leftRegistry = leftRegistry;
        this.rightRegistry = rightRegistry;
        this.leftTag = TagKey.create(leftRegistry, (ResourceLocation)name);
        this.rightTag = TagKey.create(rightRegistry, (ResourceLocation)name);
    }

    public Iterable<Holder<L>> leftValues(RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(this.leftRegistry).getTagOrEmpty(this.leftTag);
    }

    public Iterable<Holder<R>> rightValues(RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(this.rightRegistry).getTagOrEmpty(this.rightTag);
    }

    public List<Either<Holder<L>, Holder<R>>> combinedValues(RegistryAccess registryAccess) {
        ArrayList<Either<Holder<L>, Holder<R>>> list = new ArrayList<Either<Holder<L>, Holder<R>>>();
        for (Holder<L> holder : this.leftValues(registryAccess)) {
            list.add(Either.left(holder));
        }
        for (Holder holder : this.rightValues(registryAccess)) {
            list.add(Either.right((Object)holder));
        }
        return list;
    }

    public static <L, R> Location elementLocation(Either<Holder<L>, Holder<R>> element) {
        Optional optional;
        if (element.left().isPresent()) {
            Optional optional2 = ((Holder)element.left().get()).unwrapKey();
            if (optional2.isPresent()) {
                return new Location(((ResourceKey)optional2.get()).location(), true);
            }
        } else if (element.right().isPresent() && (optional = ((Holder)element.right().get()).unwrapKey()).isPresent()) {
            return new Location(((ResourceKey)optional.get()).location(), false);
        }
        return null;
    }

    public record Location(ResourceLocation location, boolean isLeft) {
        public String serialise() {
            return (this.isLeft ? "L-" : "R-") + String.valueOf(this.location);
        }

        public static Location deserialise(String serialisedElement) {
            String[] parts = serialisedElement.split("-");
            return new Location(ResourceLocation.parse((String)parts[1]), "L".equals(parts[0]));
        }
    }
}

