/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import tallestred.piglinproliferation.common.entities.PiglinTraveler;
import tallestred.piglinproliferation.common.items.component.PPComponents;
import tallestred.piglinproliferation.common.items.component.TravelersCompassTracker;
import tallestred.piglinproliferation.common.loot.PPLoot;
import tallestred.piglinproliferation.common.tags.EitherTag;

public class AddLocationToCompassFunction
extends LootItemConditionalFunction {
    public static final MapCodec<AddLocationToCompassFunction> CODEC = RecordCodecBuilder.mapCodec(builder -> AddLocationToCompassFunction.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, AddLocationToCompassFunction::new));

    AddLocationToCompassFunction(List<LootItemCondition> pPredicates) {
        super(pPredicates);
    }

    protected ItemStack run(ItemStack itemStack, LootContext lootContext) {
        Object object = lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (object instanceof PiglinTraveler) {
            PiglinTraveler traveler = (PiglinTraveler)((Object)object);
            EitherTag.Location searchObjectLocation = traveler.currentlyLocatedObject.getKey();
            traveler.alreadyLocatedObjects.put(searchObjectLocation, 24000);
            itemStack.set(PPComponents.TRAVELERS_COMPASS_TRACKER, (Object)new TravelersCompassTracker(new GlobalPos(lootContext.getLevel().dimension(), traveler.currentlyLocatedObject.getValue()), searchObjectLocation.location(), searchObjectLocation.isLeft()));
            traveler.currentlyLocatedObject = null;
        }
        return itemStack;
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)PPLoot.ADD_LOCATION_TO_COMPASS.get();
    }
}

