/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.items;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import tallestred.piglinproliferation.common.items.component.PPComponents;
import tallestred.piglinproliferation.common.items.component.TravelersCompassTracker;
import tallestred.piglinproliferation.util.CodeUtilities;

public class TravelersCompassItem
extends CompassItem {
    private static final String TRANSLATION_PREFIX = "item.piglinproliferation.travelers_compass.desc.";

    public TravelersCompassItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltip) {
        TravelersCompassTracker tracker = (TravelersCompassTracker)stack.get(PPComponents.TRAVELERS_COMPASS_TRACKER);
        if (tracker != null) {
            list.add((Component)Component.translatable((String)"item.piglinproliferation.travelers_compass.desc.locked").withStyle(ChatFormatting.BLUE));
            list.add((Component)this.translatable(tracker.targetID(), tracker.isBiome()).withStyle(ChatFormatting.GRAY));
            BlockPos pos = tracker.target().pos();
            list.add((Component)Component.translatable((String)(pos.getX() + ", " + (tracker.isBiome() ? String.valueOf(pos.getY()) : "~") + ", " + pos.getZ())).withStyle(ChatFormatting.GRAY));
        }
    }

    public MutableComponent translatable(ResourceLocation location, boolean isBiome) {
        String objectKey = (isBiome ? "biome" : "structure") + "." + location.getNamespace() + "." + location.getPath();
        String manualKey = TRANSLATION_PREFIX + objectKey;
        MutableComponent returnComponent = Component.translatableWithFallback((String)manualKey, (String)"");
        if (returnComponent.getString().isEmpty()) {
            returnComponent = Component.translatableWithFallback((String)objectKey, (String)CodeUtilities.snakeCaseToEnglish(location.getPath()));
        }
        return returnComponent;
    }

    public Optional<BlockPos> search(Either<Holder<Biome>, Holder<Structure>> searchObject, BlockPos sourcePos, ServerLevel level) {
        Pair output = searchObject.left().isPresent() ? level.findClosestBiome3d(holder -> holder.equals(searchObject.left().orElseThrow()), sourcePos, 64000, 32, 64) : level.getChunkSource().getGenerator().findNearestMapStructure(level, (HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)searchObject.right().orElseThrow()}), sourcePos, 50, false);
        return output != null ? Optional.of((BlockPos)output.getFirst()) : Optional.empty();
    }

    public boolean entityAtSearchObject(Either<Holder<Biome>, Holder<Structure>> searchObject, LivingEntity entity) {
        ServerLevel level;
        BlockPos blockPos = entity.getOnPos();
        Level level2 = entity.level();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).isLoaded(blockPos)) {
            return searchObject.left().isPresent() ? ((Biome)level.getBiome(blockPos).value()).equals(((Holder)searchObject.left().orElseThrow()).value()) : level.structureManager().getStructureWithPieceAt(blockPos, (Structure)((Holder)searchObject.right().orElseThrow()).value()).isValid();
        }
        return false;
    }
}

