/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.items;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tallestred.piglinproliferation.common.blocks.PPBlocks;
import tallestred.piglinproliferation.common.blocks.PiglinSkullBlock;
import tallestred.piglinproliferation.common.blocks.PiglinWallSkullBlock;
import tallestred.piglinproliferation.common.entities.PPEntityTypes;
import tallestred.piglinproliferation.common.items.BucklerItem;
import tallestred.piglinproliferation.common.items.TravelersCompassItem;
import tallestred.piglinproliferation.common.items.component.PPComponents;

public class PPItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"piglinproliferation");
    public static final DeferredHolder<Item, BucklerItem> BUCKLER = ITEMS.register("buckler", () -> new BucklerItem(new Item.Properties().component(PPComponents.BUCKLER_IS_READY, (Object)false).component(PPComponents.BUCKLER_CHARGE_TICKS, (Object)0).durability(128)));
    public static final DeferredHolder<Item, TravelersCompassItem> TRAVELERS_COMPASS = ITEMS.register("travelers_compass", () -> new TravelersCompassItem(new Item.Properties()));
    public static final DeferredHolder<Item, DeferredSpawnEggItem> PIGLIN_ALCHEMIST_SPAWN_EGG = ITEMS.register("piglin_alchemist_spawn_egg", () -> new DeferredSpawnEggItem(PPEntityTypes.PIGLIN_ALCHEMIST, 10944611, 16380836, new Item.Properties()));
    public static final DeferredHolder<Item, DeferredSpawnEggItem> PIGLIN_TRAVELER_SPAWN_EGG = ITEMS.register("piglin_traveler_spawn_egg", () -> new DeferredSpawnEggItem(PPEntityTypes.PIGLIN_TRAVELER, 3848107, 16380836, new Item.Properties()));
    public static final Map<DeferredHolder<Item, Item>, DeferredHolder<Block, PiglinSkullBlock>> PIGLIN_HEADS = new HashMap<DeferredHolder<Item, Item>, DeferredHolder<Block, PiglinSkullBlock>>();
    public static final DeferredHolder<Item, Item> PIGLIN_BRUTE_HEAD_ITEM = PPItems.registerHead(PPBlocks.PIGLIN_BRUTE_HEAD, PPBlocks.PIGLIN_BRUTE_HEAD_WALL);
    public static final DeferredHolder<Item, Item> ZOMBIFIED_PIGLIN_HEAD_ITEM = PPItems.registerHead(PPBlocks.ZOMBIFIED_PIGLIN_HEAD, PPBlocks.ZOMBIFIED_PIGLIN_HEAD_WALL);
    public static final DeferredHolder<Item, Item> PIGLIN_ALCHEMIST_HEAD_ITEM = PPItems.registerHead(PPBlocks.PIGLIN_ALCHEMIST_HEAD, PPBlocks.PIGLIN_ALCHEMIST_HEAD_WALL);
    public static final DeferredHolder<Item, Item> PIGLIN_TRAVELER_HEAD_ITEM = PPItems.registerHead(PPBlocks.PIGLIN_TRAVELER_HEAD, PPBlocks.PIGLIN_TRAVELER_HEAD_WALL);
    public static final DeferredHolder<Item, Item> STONE_FIRE_RING_ITEM = ITEMS.register("stone_fire_ring", () -> new BlockItem((Block)PPBlocks.STONE_FIRE_RING.get(), new Item.Properties()));
    public static final DeferredHolder<Item, Item> STONE_SOUL_FIRE_RING_ITEM = ITEMS.register("stone_soul_fire_ring", () -> new BlockItem((Block)PPBlocks.STONE_SOUL_FIRE_RING.get(), new Item.Properties()));
    public static final DeferredHolder<Item, Item> DEEPSLATE_FIRE_RING_ITEM = ITEMS.register("deepslate_fire_ring", () -> new BlockItem((Block)PPBlocks.DEEPSLATE_FIRE_RING.get(), new Item.Properties()));
    public static final DeferredHolder<Item, Item> DEEPSLATE_SOUL_FIRE_RING_ITEM = ITEMS.register("deepslate_soul_fire_ring", () -> new BlockItem((Block)PPBlocks.DEEPSLATE_SOUL_FIRE_RING.get(), new Item.Properties()));
    public static final DeferredHolder<Item, Item> NETHERRACK_FIRE_RING_ITEM = ITEMS.register("netherrack_fire_ring", () -> new BlockItem((Block)PPBlocks.NETHERRACK_FIRE_RING.get(), new Item.Properties()));
    public static final DeferredHolder<Item, Item> NETHERRACK_SOUL_FIRE_RING_ITEM = ITEMS.register("netherrack_soul_fire_ring", () -> new BlockItem((Block)PPBlocks.NETHERRACK_SOUL_FIRE_RING.get(), new Item.Properties()));
    public static final DeferredHolder<Item, Item> BLACKSTONE_FIRE_RING_ITEM = ITEMS.register("blackstone_fire_ring", () -> new BlockItem((Block)PPBlocks.BLACKSTONE_FIRE_RING.get(), new Item.Properties()));
    public static final DeferredHolder<Item, Item> BLACKSTONE_SOUL_FIRE_RING_ITEM = ITEMS.register("blackstone_soul_fire_ring", () -> new BlockItem((Block)PPBlocks.BLACKSTONE_SOUL_FIRE_RING.get(), new Item.Properties()));
    public static final DeferredHolder<Item, Item> END_STONE_FIRE_RING_ITEM = ITEMS.register("end_stone_fire_ring", () -> new BlockItem((Block)PPBlocks.END_STONE_FIRE_RING.get(), new Item.Properties()));
    public static final DeferredHolder<Item, Item> END_STONE_SOUL_FIRE_RING_ITEM = ITEMS.register("end_stone_soul_fire_ring", () -> new BlockItem((Block)PPBlocks.END_STONE_SOUL_FIRE_RING.get(), new Item.Properties()));

    public static ItemStack checkEachHandForBuckler(LivingEntity entity) {
        InteractionHand hand = entity.getMainHandItem().getItem() instanceof BucklerItem ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        return entity.getItemInHand(hand);
    }

    private static DeferredHolder<Item, Item> registerHead(DeferredHolder<Block, PiglinSkullBlock> head, DeferredHolder<Block, PiglinWallSkullBlock> wallHead) {
        DeferredHolder registeredItem = ITEMS.register(((ResourceKey)head.unwrapKey().orElseThrow()).location().getPath(), () -> new StandingAndWallBlockItem((Block)head.get(), (Block)wallHead.get(), new Item.Properties().rarity(Rarity.UNCOMMON), Direction.DOWN));
        PIGLIN_HEADS.put((DeferredHolder<Item, Item>)registeredItem, head);
        return registeredItem;
    }

    public static Item headItem(EntityType<?> entityType) {
        for (Map.Entry<DeferredHolder<Item, Item>, DeferredHolder<Block, PiglinSkullBlock>> entry : PIGLIN_HEADS.entrySet()) {
            if (((PiglinSkullBlock)((Object)entry.getValue().get())).getType().getEntityType() != entityType) continue;
            return (Item)entry.getKey().get();
        }
        return null;
    }
}

