/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.items;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import tallestred.piglinproliferation.capablities.PPDataAttachments;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.client.particles.ParticleHelper;
import tallestred.piglinproliferation.common.attribute.AttributeModifierHolder;
import tallestred.piglinproliferation.common.attribute.PPAttributes;
import tallestred.piglinproliferation.common.attribute.RangedRandomAttributeModifierHolder;
import tallestred.piglinproliferation.common.enchantments.PPEnchantments;
import tallestred.piglinproliferation.common.items.component.PPComponents;
import tallestred.piglinproliferation.configuration.PPConfig;
import tallestred.piglinproliferation.util.CodeUtilities;

public class BucklerItem
extends ShieldItem {
    public static final AttributeModifierHolder CHARGE_SPEED_BOOST = new AttributeModifierHolder((Holder<Attribute>)Attributes.MOVEMENT_SPEED, "charge_speed_boost", 9.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    public static final AttributeModifierHolder INCREASED_KNOCKBACK_RESISTANCE = new AttributeModifierHolder((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, "increased_knockback_resistance", 1.0, AttributeModifier.Operation.ADD_VALUE);
    public static final AttributeModifierHolder CHARGE_JUMP_PREVENTION = new AttributeModifierHolder((Holder<Attribute>)Attributes.JUMP_STRENGTH, "charge_jump_prevention", -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final AttributeModifierHolder TURNING_SPEED_REDUCTION = new AttributeModifierHolder((Holder<Attribute>)PPAttributes.TURNING_SPEED, "turning_speed_reduction", -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final RangedRandomAttributeModifierHolder ATTACK_DAMAGE = new RangedRandomAttributeModifierHolder((Holder<Attribute>)Attributes.ATTACK_DAMAGE, "attack_damage", 6.0, 8.0, AttributeModifier.Operation.ADD_VALUE);

    public BucklerItem(Item.Properties p_i48470_1_) {
        super(p_i48470_1_);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)ArmorItem.DISPENSE_ITEM_BEHAVIOR);
    }

    public static void moveFowards(LivingEntity entity) {
        if (entity.isAlive()) {
            Vec3 look = entity.getViewVector(1.0f);
            Vec3 motion = entity.getDeltaMovement();
            if (entity.level().isClientSide) {
                float yHeadRot = entity.yHeadRot + 180.0f;
                if (((Boolean)PPConfig.CLIENT.RenderAfterImage.get()).booleanValue()) {
                    ParticleHelper.createAfterImage(entity, Vec3.directionFromRotation((float)0.0f, (float)yHeadRot));
                }
            }
            if (entity instanceof Player) {
                entity.setDeltaMovement(look.x * entity.getAttributeValue(Attributes.MOVEMENT_SPEED), motion.y, look.z * entity.getAttributeValue(Attributes.MOVEMENT_SPEED));
            } else {
                entity.setDeltaMovement(look.x, motion.y, look.z);
            }
        }
    }

    public static boolean isReady(ItemStack stack) {
        return (Boolean)stack.getOrDefault(PPComponents.BUCKLER_IS_READY, (Object)false);
    }

    public static int startingChargeTicks(ItemStack stack, Level level) {
        int min = (Integer)PPConfig.COMMON.minBucklerChargeTime.get();
        int max = (Integer)PPConfig.COMMON.maxBucklerChargeTime.get();
        return min + (max - min) * stack.getEnchantmentLevel(PPEnchantments.getEnchant(PPEnchantments.TURNING, level.registryAccess())) / 5;
    }

    public static int getChargeTicks(ItemStack stack) {
        return (Integer)stack.getOrDefault(PPComponents.BUCKLER_CHARGE_TICKS, (Object)0);
    }

    public static void setChargeTicks(ItemStack stack, Level level) {
        BucklerItem.setChargeTicks(stack, BucklerItem.startingChargeTicks(stack, level));
    }

    public static void setChargeTicks(ItemStack stack, int chargeTicks) {
        stack.set(PPComponents.BUCKLER_CHARGE_TICKS, (Object)chargeTicks);
    }

    public static void setReady(ItemStack stack, boolean ready) {
        stack.set(PPComponents.BUCKLER_IS_READY, (Object)ready);
    }

    public static void bucklerBash(LivingEntity entity) {
        List list = entity.level().getNearbyEntities(LivingEntity.class, TargetingConditions.forCombat(), entity, entity.getBoundingBox().inflate(1.5));
        if (!list.isEmpty()) {
            LivingEntity entityHit = (LivingEntity)list.getFirst();
            entityHit.push((Entity)entity);
            if (entityHit.invulnerableTime <= 0) {
                Player player;
                int bangLevel = PPEnchantments.getBucklerEnchantsOnHands(PPEnchantments.BANG, entity);
                int turningLevel = PPEnchantments.getBucklerEnchantsOnHands(PPEnchantments.TURNING, entity);
                RangedRandomAttributeModifierHolder.Instance attackDamage = ATTACK_DAMAGE.getWithSummands(BucklerItem.minDamageReduction(turningLevel), BucklerItem.maxDamageReduction(turningLevel));
                float damage = attackDamage.randomIntAmount();
                float knockbackStrength = 3.0f;
                for (int duration = 0; duration < 10; ++duration) {
                    double d0 = entity.getRandom().nextGaussian() * 0.02;
                    double d1 = entity.getRandom().nextGaussian() * 0.02;
                    double d2 = entity.getRandom().nextGaussian() * 0.02;
                    SimpleParticleType type = entityHit instanceof WitherBoss || entityHit instanceof WitherSkeleton ? ParticleTypes.SMOKE : ParticleTypes.CLOUD;
                    ((ServerLevel)entity.level()).sendParticles((ParticleOptions)type, entity.getRandomX(1.0), entity.getRandomY() + 1.0, entity.getRandomZ(1.0), 1, d0, d1, d2, 1.0);
                }
                if (bangLevel == 0) {
                    if (entityHit.hurt(entity.damageSources().mobAttack(entity), damage)) {
                        entityHit.knockback((double)knockbackStrength, (double)Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180)))));
                        entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                    }
                    if (!entity.isSilent()) {
                        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)PPSounds.SHIELD_BASH.get(), entity.getSoundSource(), 0.5f, 0.8f + entity.getRandom().nextFloat() * 0.4f);
                    }
                    if (entityHit instanceof Player && entityHit.getUseItem().canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
                        ((Player)entityHit).disableShield();
                    }
                } else {
                    boolean isInMainHand = entity.getMainHandItem().getItem() instanceof BucklerItem;
                    ItemStack stack = entity.getItemInHand(isInMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                    stack.hurtAndBreak(2 * bangLevel, entity, isInMainHand ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    Level.ExplosionInteraction mode = (Boolean)PPConfig.COMMON.BangBlockDestruction.get() != false ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE;
                    entity.level().explode(null, entity.getX(), entity.getY(), entity.getZ(), (float)bangLevel, mode);
                    BucklerItem.setChargeTicks(stack, 0);
                }
                entity.setLastHurtMob((Entity)entityHit);
                if (entity instanceof Player && !PPEnchantments.hasBucklerEnchantsOnHands((LivingEntity)(player = (Player)entity), PPEnchantments.BANG, PPEnchantments.TURNING) && ((Boolean)PPConfig.COMMON.criticalAura.get()).booleanValue()) {
                    player.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)PPSounds.CRITICAL_ACTIVATE.get(), entity.getSoundSource(), 1.0f, 1.0f);
                    player.setData(PPDataAttachments.CRITICAL.get(), (Object)true);
                }
            }
        }
    }

    public static void spawnRunningEffectsWhileCharging(LivingEntity entity) {
        int i = Mth.floor((double)entity.getX());
        int j = Mth.floor((double)(entity.getY() - (double)0.2f));
        int k = Mth.floor((double)entity.getZ());
        BlockPos blockpos = new BlockPos(i, j, k);
        BlockState blockstate = entity.level().getBlockState(blockpos);
        if (!blockstate.addRunningEffects(entity.level(), blockpos, (Entity)entity) && blockstate.getRenderShape() != RenderShape.INVISIBLE) {
            Vec3 vec3 = entity.getDeltaMovement();
            entity.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate).setPos(blockpos), entity.getX() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getDimensions(entity.getPose()).height(), entity.getY() + 0.1, entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getDimensions(entity.getPose()).width(), vec3.x * -4.0, 1.5, vec3.z * -4.0);
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entity) {
        ItemStack itemstack = super.finishUsingItem(stack, worldIn, entity);
        BucklerItem.setReady(stack, true);
        BucklerItem.setChargeTicks(stack, worldIn);
        CHARGE_SPEED_BOOST.get().resetTransientModifier(entity);
        CHARGE_JUMP_PREVENTION.get().resetTransientModifier(entity);
        INCREASED_KNOCKBACK_RESISTANCE.get().resetTransientModifier(entity);
        TURNING_SPEED_REDUCTION.getWithSummand(BucklerItem.turningReduction(stack.getEnchantmentLevel(PPEnchantments.getEnchant(PPEnchantments.TURNING, entity.registryAccess())))).resetTransientModifier(entity);
        stack.hurtAndBreak(1, entity, EquipmentSlot.OFFHAND);
        if (entity instanceof Player) {
            ((Player)entity).getCooldowns().addCooldown((Item)this, ((Integer)PPConfig.COMMON.bucklerCooldown.get()).intValue());
        }
        entity.stopUsingItem();
        if (entity instanceof AbstractPiglin) {
            entity.playSound((SoundEvent)PPSounds.PIGLIN_BRUTE_CHARGE.get(), 2.0f, entity.isBaby() ? (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.5f : (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        }
        return itemstack;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity entity) {
        return 10;
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        return !playerIn.isInWaterRainOrBubble() ? super.use(worldIn, playerIn, handIn) : InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is(Tags.Items.INGOTS_GOLD);
    }

    public List<Component> getDescription(ItemStack stack) {
        Minecraft minecraft = Minecraft.getInstance();
        boolean isDetailed = Screen.hasShiftDown();
        int turningLevel = stack.getEnchantmentLevel(PPEnchantments.getEnchant(PPEnchantments.TURNING, minecraft.player.registryAccess()));
        boolean isBang = stack.getEnchantmentLevel(PPEnchantments.getEnchant(PPEnchantments.BANG, minecraft.player.registryAccess())) > 0;
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.translatable((String)"item.piglinproliferation.buckler.desc.on_use").withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"item.piglinproliferation.buckler.desc.charge_ability", (Object[])new Object[]{CodeUtilities.doubleToString(CodeUtilities.ticksToSeconds(BucklerItem.startingChargeTicks(stack, minecraft.player.level())))}).withStyle(ChatFormatting.DARK_GREEN)));
        if (((Boolean)PPConfig.CLIENT.verboseBucklerDesc.get()).booleanValue()) {
            if (!isDetailed) {
                list.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"item.piglinproliferation.buckler.desc.details", (Object[])new Object[]{minecraft.options.keyShift.getDefaultKey().getDisplayName()}).withStyle(ChatFormatting.GREEN)));
            } else {
                list.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"item.piglinproliferation.buckler.desc.while_charging").withStyle(ChatFormatting.GREEN)));
                list.add((Component)Component.literal((String)"  ").append((Component)CHARGE_SPEED_BOOST.get().translatable()));
                list.add((Component)Component.literal((String)"  ").append((Component)INCREASED_KNOCKBACK_RESISTANCE.get().translatable()));
                list.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)"item.piglinproliferation.buckler.desc.shield_bash").withStyle(ChatFormatting.BLUE)));
                if ((Double)PPConfig.COMMON.turningBucklerLaunchStrength.get() > 0.0 && turningLevel > 0) {
                    list.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)"item.piglinproliferation.buckler.desc.launch").withStyle(ChatFormatting.BLUE)));
                }
                if (turningLevel != 5) {
                    list.add((Component)Component.literal((String)"  ").append((Component)TURNING_SPEED_REDUCTION.getWithSummand(BucklerItem.turningReduction(turningLevel)).translatable()));
                }
                list.add((Component)Component.literal((String)"  ").append((Component)CHARGE_JUMP_PREVENTION.get().translatable()));
                list.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)"item.piglinproliferation.buckler.desc.water").withStyle(ChatFormatting.RED)));
                list.add((Component)Component.translatable((String)"item.piglinproliferation.buckler.desc.on_shield_bash").withStyle(ChatFormatting.GRAY));
                if (isBang) {
                    list.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"item.piglinproliferation.buckler.desc.explosion").withStyle(ChatFormatting.DARK_GREEN)));
                } else {
                    list.add((Component)Component.literal((String)" ").append((Component)ATTACK_DAMAGE.getWithSummands(BucklerItem.minDamageReduction(turningLevel), BucklerItem.maxDamageReduction(turningLevel)).translatable(0.0)));
                    if (turningLevel <= 0 && ((Boolean)PPConfig.COMMON.criticalAura.get()).booleanValue()) {
                        list.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"item.piglinproliferation.buckler.desc.critical_aura").withStyle(ChatFormatting.DARK_GREEN)));
                        list.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"item.piglinproliferation.buckler.desc.critical_aura_expires").withStyle(ChatFormatting.RED)));
                    }
                }
            }
        }
        return list;
    }

    public static double turningReduction(int turningLevel) {
        return 0.2 * (double)turningLevel;
    }

    public static int minDamageReduction(int turningLevel) {
        return -1 * turningLevel;
    }

    public static int maxDamageReduction(int turningLevel) {
        return Math.round((float)((double)BucklerItem.minDamageReduction(turningLevel) * 1.2));
    }
}

