/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import tallestred.piglinproliferation.PPActivities;
import tallestred.piglinproliferation.PPMemoryModules;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;
import tallestred.piglinproliferation.common.entities.ai.behaviors.BaseThrowPotion;
import tallestred.piglinproliferation.util.CodeUtilities;

public class ThrowPotionAtTargetTask<E extends PiglinAlchemist>
extends BaseThrowPotion<E> {
    protected final Predicate<Mob> nearbyPiglinPredicate;

    public ThrowPotionAtTargetTask(ItemStack stack, Predicate<PiglinAlchemist> pCanUseSelector, Predicate<Mob> nearbyPiglinPredicate) {
        super(stack, pCanUseSelector);
        this.nearbyPiglinPredicate = nearbyPiglinPredicate;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E alchemist) {
        List list = alchemist.level().getEntitiesOfClass(AbstractPiglin.class, alchemist.getBoundingBox().inflate(10.0, 3.0, 10.0));
        if (!list.isEmpty()) {
            for (AbstractPiglin piglin : list) {
                if (piglin == alchemist) continue;
                for (MobEffectInstance mobeffectinstance : CodeUtilities.potionContents(this.itemToUse).getAllEffects()) {
                    List<AbstractPiglin> listOfAlchemists = list.stream().filter(abstractPiglin -> abstractPiglin != alchemist && abstractPiglin instanceof PiglinAlchemist).toList();
                    if (piglin == null || !alchemist.hasLineOfSight((Entity)piglin) || !listOfAlchemists.stream().noneMatch(abstractPiglin -> ((PiglinAlchemist)((Object)abstractPiglin)).isGonnaThrowPotion()) || !super.checkExtraStartConditions(level, alchemist) || !this.nearbyPiglinPredicate.test((Mob)piglin) || piglin.hasEffect(mobeffectinstance.getEffect())) continue;
                    if (piglin.getTarget() != null && listOfAlchemists.size() < 2 && alchemist.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty()).find(livingEntity -> livingEntity instanceof Mob && ((Mob)livingEntity).getTarget() instanceof AbstractPiglin || livingEntity.getLastHurtMob() instanceof AbstractPiglin).toList().size() > 1) {
                        return false;
                    }
                    alchemist.getBrain().setMemory((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get(), (Object)piglin);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean canStillUse(ServerLevel level, E alchemist, long gameTime) {
        if (alchemist.getBrain().hasMemoryValue((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get())) {
            Mob throwTarget = (Mob)alchemist.getBrain().getMemory((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()).get();
            Iterator iterator = CodeUtilities.potionContents(this.itemToUse).getAllEffects().iterator();
            if (iterator.hasNext()) {
                MobEffectInstance mobeffectinstance = (MobEffectInstance)iterator.next();
                return throwTarget != null && alchemist.hasLineOfSight((Entity)throwTarget) && this.nearbyPiglinPredicate.test(throwTarget) && !throwTarget.hasEffect(mobeffectinstance.getEffect()) && this.ticksUntilThrow > 0;
            }
            return throwTarget != null && alchemist.hasLineOfSight((Entity)throwTarget);
        }
        return false;
    }

    @Override
    protected void start(ServerLevel level, E alchemist, long gameTime) {
        if (alchemist.getBrain().hasMemoryValue((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get())) {
            super.start(level, alchemist, gameTime);
            alchemist.getBrain().setActiveActivityIfPossible((Activity)PPActivities.THROW_POTION_ACTIVITY.get());
            Mob throwTarget = (Mob)alchemist.getBrain().getMemory((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()).get();
            if (throwTarget == null) {
                return;
            }
            if (this.ticksUntilThrow <= 0) {
                this.ticksUntilThrow = 20;
            }
        }
    }

    @Override
    protected void stop(ServerLevel level, E alchemist, long gameTime) {
        super.stop(level, alchemist, gameTime);
        alchemist.getBrain().eraseMemory((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get());
        this.ticksUntilThrow = 0;
        this.panicTicks = 0;
    }

    protected void tick(ServerLevel level, E alchemist, long gameTime) {
        Mob throwTarget = (Mob)alchemist.getBrain().getMemory((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()).orElseGet(null);
        if (throwTarget == null) {
            return;
        }
        alchemist.lookAt((Entity)throwTarget, 30.0f, 30.0f);
        BehaviorUtils.lookAtEntity(alchemist, (LivingEntity)throwTarget);
        BehaviorUtils.lookAtEntity((LivingEntity)throwTarget, alchemist);
        alchemist.getLookControl().setLookAt((Entity)throwTarget);
        if ((double)alchemist.distanceTo((Entity)throwTarget) > 5.0) {
            alchemist.getNavigation().moveTo((Entity)throwTarget, 1.0);
        } else {
            alchemist.getNavigation().stop();
        }
        List list = alchemist.level().getEntitiesOfClass(LivingEntity.class, alchemist.getBoundingBox().inflate(5.0, 3.0, 5.0));
        if (!list.isEmpty()) {
            for (LivingEntity entity : list) {
                Vec3 vec3;
                if ((throwTarget.getTarget() == null || throwTarget.getTarget() != entity) && (!(entity instanceof Mob) || ((Mob)entity).getTarget() == null || ((Mob)entity).getTarget() != alchemist && ((Mob)entity).getTarget() != throwTarget) || !((double)entity.distanceTo((Entity)throwTarget) <= 4.0) && !((double)entity.distanceTo(alchemist) <= 4.0)) continue;
                if (this.panicTicks <= 0) {
                    this.panicTicks = 5;
                }
                this.ticksUntilThrow += 5;
                if (--this.panicTicks <= 0 || (vec3 = this.getPosition((PiglinAlchemist)((Object)alchemist))) == null || !alchemist.getNavigation().isDone()) continue;
                alchemist.getNavigation().moveTo(vec3.x, vec3.y, vec3.z, 1.5);
            }
        }
        if (this.ticksUntilThrow > 20) {
            this.ticksUntilThrow = 20;
        }
        if (this.panicTicks < 0) {
            this.panicTicks = 0;
        }
        if (this.panicTicks >= 15) {
            this.panicTicks = 15;
        }
        if (!alchemist.hasLineOfSight((Entity)throwTarget)) {
            this.ticksUntilThrow += 5;
        }
        if (this.ticksUntilThrow == 5) {
            alchemist.playSound((SoundEvent)PPSounds.ALCHEMIST_ABOUT_TO_THROW_POTION.get(), 1.0f, 1.0f);
        }
        if (--this.ticksUntilThrow <= 0) {
            this.throwPotion(alchemist);
        }
    }

    @Nullable
    protected Vec3 getPosition(PiglinAlchemist alchemist) {
        if (alchemist.getTarget() != null) {
            return LandRandomPos.getPosAway((PathfinderMob)alchemist, (int)8, (int)7, (Vec3)alchemist.getTarget().position());
        }
        return LandRandomPos.getPos((PathfinderMob)alchemist, (int)8, (int)7);
    }
}

