/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import tallestred.piglinproliferation.PPActivities;
import tallestred.piglinproliferation.PPMemoryModules;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;
import tallestred.piglinproliferation.common.entities.ai.behaviors.BaseThrowPotion;
import tallestred.piglinproliferation.util.CodeUtilities;

public class ThrowPotionAtSelfTask<E extends PiglinAlchemist>
extends BaseThrowPotion<E> {
    public ThrowPotionAtSelfTask(ItemStack stack, Predicate<PiglinAlchemist> pCanUseSelector) {
        super(stack, pCanUseSelector);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E alchemist) {
        for (MobEffectInstance mobeffectinstance : CodeUtilities.potionContents(this.itemToUse).getAllEffects()) {
            if (!super.checkExtraStartConditions(level, alchemist)) continue;
            List list = (List)alchemist.getBrain().getMemory(MemoryModuleType.NEARBY_ADULT_PIGLINS).orElse(ImmutableList.of());
            if (alchemist.hasEffect(mobeffectinstance.getEffect())) continue;
            if (alchemist.getTarget() != null) {
                return list.size() > 2;
            }
            return !list.stream().filter(abstractPiglin -> abstractPiglin instanceof PiglinAlchemist && ((PiglinAlchemist)((Object)abstractPiglin)).isGonnaThrowPotion()).findAny().isPresent();
        }
        return false;
    }

    protected void tick(ServerLevel level, E alchemist, long gameTIme) {
        Vec3 vec3;
        BlockPos lookPos = new BlockPos((int)alchemist.position().x, (int)(alchemist.getBoundingBox().minY - 0.5000001), (int)alchemist.position().z);
        alchemist.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(lookPos));
        List list = alchemist.level().getEntitiesOfClass(LivingEntity.class, alchemist.getBoundingBox().inflate(5.0, 3.0, 5.0));
        if (!list.isEmpty()) {
            for (LivingEntity entity : list) {
                if (entity == alchemist || (alchemist.getTarget() == null || alchemist.getTarget() != entity) && (!(entity instanceof Mob) || (((Mob)entity).getTarget() == null || ((Mob)entity).getTarget() != alchemist) && (entity.getLastHurtMob() == null || !(entity.getLastHurtMob() instanceof AbstractPiglin))) || !((double)entity.distanceTo(alchemist) <= 4.0) && !((double)alchemist.distanceTo((Entity)entity) <= 4.0)) continue;
                if (this.panicTicks <= 0) {
                    this.panicTicks = 20;
                }
                this.ticksUntilThrow += 5;
            }
        }
        if (this.ticksUntilThrow > 20) {
            this.ticksUntilThrow = 20;
        }
        if (this.panicTicks >= 15) {
            this.panicTicks = 15;
        }
        if (--this.panicTicks > 0 && (vec3 = this.getPosition((PiglinAlchemist)((Object)alchemist))) != null && alchemist.getNavigation().isDone()) {
            alchemist.getNavigation().moveTo(vec3.x, vec3.y, vec3.z, 1.5);
        }
        alchemist.setYRot(Mth.rotateIfNecessary((float)alchemist.getYRot(), (float)((PiglinAlchemist)((Object)alchemist)).yHeadRot, (float)0.0f));
        alchemist.setXRot(Mth.rotateIfNecessary((float)alchemist.getXRot(), (float)alchemist.getMaxHeadXRot(), (float)0.0f));
        if (this.ticksUntilThrow == 5) {
            alchemist.playSound((SoundEvent)PPSounds.ALCHEMIST_ABOUT_TO_THROW_POTION.get(), 1.0f, 1.0f);
        }
        if (--this.ticksUntilThrow <= 0 && this.panicTicks <= 0) {
            alchemist.setYHeadRot(-200.0f);
            alchemist.setXRot(90.0f);
            this.throwPotion(alchemist);
        }
    }

    protected boolean canStillUse(ServerLevel level, E alchemist, long gameTime) {
        List list = (List)alchemist.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS).orElse(ImmutableList.of());
        if (alchemist.getTarget() != null) {
            return list.size() > 2;
        }
        Iterator iterator = CodeUtilities.potionContents(this.itemToUse).getAllEffects().iterator();
        if (iterator.hasNext()) {
            MobEffectInstance mobeffectinstance = (MobEffectInstance)iterator.next();
            return this.canUseSelector.test(alchemist) && !alchemist.hasEffect(mobeffectinstance.getEffect()) && this.ticksUntilThrow > 0;
        }
        return !list.stream().filter(abstractPiglin -> abstractPiglin instanceof PiglinAlchemist && ((PiglinAlchemist)((Object)abstractPiglin)).isGonnaThrowPotion()).findAny().isPresent();
    }

    @Override
    protected void start(ServerLevel level, E alchemist, long gameTime) {
        super.start(level, alchemist, gameTime);
        alchemist.getBrain().setMemory((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get(), alchemist);
        alchemist.getBrain().setActiveActivityIfPossible((Activity)PPActivities.THROW_POTION_ACTIVITY.get());
        if (this.ticksUntilThrow <= 0) {
            this.ticksUntilThrow = 15;
        }
    }

    @Override
    protected void stop(ServerLevel level, E alchemist, long gameTime) {
        super.stop(level, alchemist, gameTime);
        this.ticksUntilThrow = 0;
        this.panicTicks = 0;
        alchemist.getBrain().eraseMemory((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get());
    }

    @Nullable
    protected Vec3 getPosition(PiglinAlchemist alchemist) {
        return LandRandomPos.getPos((PathfinderMob)alchemist, (int)8, (int)7);
    }
}

