/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import tallestred.piglinproliferation.PPActivities;
import tallestred.piglinproliferation.PPMemoryModules;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;
import tallestred.piglinproliferation.common.entities.ai.behaviors.BowAttack;
import tallestred.piglinproliferation.util.CodeUtilities;

public class ShootTippedArrow
extends BowAttack<PiglinAlchemist, LivingEntity> {
    protected final Predicate<? super AbstractPiglin> nearbyPiglinPredicate;
    private final ItemStack itemToUse;
    private AbstractPiglin piglinToTarget;

    public ShootTippedArrow(double speedModifier, float attackRadius, int attackIntervalMin, ItemStack item, Predicate<? super AbstractPiglin> nearbyPiglinPredicate) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()), (Object)MemoryStatus.VALUE_ABSENT), speedModifier, attackRadius, attackIntervalMin);
        this.nearbyPiglinPredicate = nearbyPiglinPredicate;
        this.itemToUse = item;
    }

    @Override
    protected LivingEntity getTargetToShootAt(PiglinAlchemist alchemist) {
        List list = (List)alchemist.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS).orElse(ImmutableList.of());
        if (!list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AbstractPiglin piglin;
                this.piglinToTarget = piglin = (AbstractPiglin)iterator.next();
                for (MobEffectInstance mobeffectinstance : CodeUtilities.potionContents(this.itemToUse).getAllEffects()) {
                    List<ItemStack> filteredList = alchemist.beltInventory.getMatches(stack -> stack.is(this.itemToUse.getItem()));
                    for (ItemStack stack2 : filteredList) {
                        if (!CodeUtilities.compareOptionalHolders(CodeUtilities.potionContents(stack2).potion(), CodeUtilities.potionContents(this.itemToUse).potion())) continue;
                        return alchemist.getItemShownOnOffhand().is(this.itemToUse.getItem()) && this.nearbyPiglinPredicate.test((AbstractPiglin)this.piglinToTarget) && !this.piglinToTarget.hasEffect(mobeffectinstance.getEffect()) ? this.piglinToTarget : null;
                    }
                }
            }
        }
        return null;
    }

    protected void start(ServerLevel level, PiglinAlchemist alchemist, long gameTime) {
        alchemist.getBrain().setMemory((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get(), (Object)this.piglinToTarget);
        alchemist.getBrain().setActiveActivityIfPossible((Activity)PPActivities.THROW_POTION_ACTIVITY.get());
    }

    @Override
    protected void stop(ServerLevel level, PiglinAlchemist alchemist, long gameTime) {
        super.stop(level, alchemist, gameTime);
        if (alchemist.getItemShownOnOffhand().getItem() instanceof ArrowItem) {
            for (int slot = 0; slot < alchemist.beltInventory.size(); ++slot) {
                ItemStack stackInSlot = alchemist.beltInventory.get(slot);
                if (!stackInSlot.isEmpty()) continue;
                alchemist.beltInventory.set(slot, alchemist.getItemShownOnOffhand().copy());
                alchemist.setItemShownOnOffhand(ItemStack.EMPTY);
            }
        }
        alchemist.getBrain().eraseMemory((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get());
    }
}

