/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MoveAroundPiglins
extends RandomStroll {
    public static OneShot<PathfinderMob> moveAroundPiglins(float p_260303_, boolean p_259639_) {
        return MoveAroundPiglins.strollFlyOrSwim(p_260303_, mob -> mob.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS) != null ? MoveAroundPiglins.getTargetPos(mob) : LandRandomPos.getPos((PathfinderMob)mob, (int)10, (int)7), p_259639_ ? p_258615_ -> true : p_258613_ -> !p_258613_.isInWaterOrBubble());
    }

    private static OneShot<PathfinderMob> strollFlyOrSwim(float p_260030_, Function<PathfinderMob, Vec3> p_259912_, Predicate<PathfinderMob> p_259088_) {
        return BehaviorBuilder.create(p_258620_ -> p_258620_.group((App)p_258620_.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)p_258620_, p_258600_ -> (p_258610_, p_258611_, p_258612_) -> {
            if (!p_259088_.test((PathfinderMob)p_258611_)) {
                return false;
            }
            Optional<Vec3> optional = Optional.ofNullable((Vec3)p_259912_.apply((PathfinderMob)p_258611_));
            p_258600_.setOrErase(optional.map(p_258622_ -> new WalkTarget(p_258622_, p_260030_, 0)));
            return true;
        }));
    }

    @Nullable
    protected static Vec3 getTargetPos(PathfinderMob alchemist) {
        Iterator iterator = ((List)alchemist.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS).orElse(ImmutableList.of())).iterator();
        if (iterator.hasNext()) {
            AbstractPiglin piglin = (AbstractPiglin)iterator.next();
            if (((List)alchemist.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS).orElse(ImmutableList.of())).size() >= 2) {
                return LandRandomPos.getPosTowards((PathfinderMob)alchemist, (int)4, (int)3, (Vec3)piglin.position());
            }
            return null;
        }
        return null;
    }
}

