/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import tallestred.piglinproliferation.common.enchantments.PPEnchantments;
import tallestred.piglinproliferation.common.items.BucklerItem;
import tallestred.piglinproliferation.common.items.PPItems;
import tallestred.piglinproliferation.configuration.PPConfig;

public class ChargeTask<T extends PiglinBrute>
extends Behavior<T> {
    private ChargePhases chargePhase = ChargePhases.NONE;
    private long nextOkStartTime;
    private int strafeTicks;

    public ChargeTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), 1200);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, T owner) {
        LivingEntity livingentity = this.getAttackTarget(owner);
        return worldIn.getGameTime() - this.nextOkStartTime > (long)((Integer)PPConfig.COMMON.bucklerCooldown.get()).intValue() && livingentity != null && (double)livingentity.distanceTo(owner) >= 4.0 && BehaviorUtils.canSee(owner, (LivingEntity)livingentity) && owner.getOffhandItem().getItem() instanceof BucklerItem && !owner.isInWaterRainOrBubble();
    }

    protected boolean canStillUse(ServerLevel worldIn, T entityIn, long gameTimeIn) {
        LivingEntity livingentity = this.getAttackTarget(entityIn);
        return livingentity != null && entityIn.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && entityIn.getOffhandItem().getItem() instanceof BucklerItem && !entityIn.isInWaterRainOrBubble() && this.chargePhase != ChargePhases.FINISH;
    }

    private LivingEntity getAttackTarget(T mob) {
        return mob.getTarget();
    }

    protected void tick(ServerLevel worldIn, T entityIn, long gameTime) {
        LivingEntity livingEntity = this.getAttackTarget(entityIn);
        if (this.chargePhase == ChargePhases.STRAFE && this.strafeTicks > 0 && (double)entityIn.distanceTo((Entity)livingEntity) >= 4.0 && (double)entityIn.distanceTo((Entity)livingEntity) <= 10.0) {
            entityIn.getMoveControl().strafe(-2.0f, 0.0f);
            --this.strafeTicks;
            if (this.strafeTicks == 0) {
                this.chargePhase = ChargePhases.CHARGE;
            }
            if (BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(entityIn)) > 0 && PPEnchantments.getBucklerEnchantsOnHands(PPEnchantments.TURNING, entityIn) > 0 || BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(entityIn)) <= 0) {
                entityIn.lookAt((Entity)livingEntity, 30.0f, 30.0f);
            }
        } else if (this.chargePhase == ChargePhases.CHARGE) {
            if (!entityIn.isUsingItem() && BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(entityIn)) <= 0) {
                entityIn.startUsingItem(InteractionHand.OFF_HAND);
            }
            if (entityIn.getTicksUsingItem() >= entityIn.getUseItem().getUseDuration(entityIn)) {
                this.chargePhase = ChargePhases.CHARGING;
            }
        } else if (this.chargePhase == ChargePhases.CHARGING && BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(entityIn)) <= 0) {
            this.chargePhase = ChargePhases.FINISH;
        }
    }

    protected void start(ServerLevel worldIn, T entityIn, long gameTimeIn) {
        this.chargePhase = ChargePhases.STRAFE;
        this.strafeTicks = 20;
    }

    protected void stop(ServerLevel worldIn, T entityIn, long gameTimeIn) {
        if (entityIn.isUsingItem()) {
            entityIn.stopUsingItem();
        }
        this.nextOkStartTime = gameTimeIn;
    }

    public static enum ChargePhases {
        NONE,
        STRAFE,
        CHARGE,
        CHARGING,
        FINISH;

    }
}

