/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;

public class BowAttack<E extends PiglinAlchemist, T extends LivingEntity>
extends Behavior<E> {
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int attackIntervalMin;
    private Path path;
    private int attackTime = -1;
    private int seeTime;
    private int avoidTime;

    public BowAttack(Map<MemoryModuleType<?>, MemoryStatus> map, double speedModifier, float attackRadius, int attackIntervalMin) {
        super(map, 12000);
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.attackIntervalMin = attackIntervalMin;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E alchemist) {
        LivingEntity target = this.getTargetToShootAt((PiglinAlchemist)((Object)alchemist));
        return alchemist.isHolding(is -> is.getItem() instanceof BowItem) && BehaviorUtils.canSee(alchemist, (LivingEntity)target);
    }

    protected boolean canStillUse(ServerLevel level, E alchemist, long gameTime) {
        LivingEntity target = this.getTargetToShootAt((PiglinAlchemist)((Object)alchemist));
        return target != null && this.checkExtraStartConditions(level, alchemist);
    }

    protected void tick(ServerLevel level, E alchemist, long gameTime) {
        LivingEntity target = this.getTargetToShootAt((PiglinAlchemist)((Object)alchemist));
        if (target != null) {
            double distanceSquared = alchemist.distanceToSqr((Entity)target);
            boolean canSee = alchemist.getSensing().hasLineOfSight((Entity)target);
            boolean seeTimeGreaterThanZero = this.seeTime > 0;
            alchemist.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
            alchemist.getLookControl().setLookAt((Entity)target);
            alchemist.lookAt((Entity)target, 30.0f, 30.0f);
            if (alchemist.isUsingItem()) {
                if (!canSee && this.seeTime < -60) {
                    alchemist.stopUsingItem();
                } else if (canSee) {
                    int timeToShoot;
                    int i = alchemist.getTicksUsingItem();
                    int n = timeToShoot = distanceSquared <= 40.0 ? Mth.floor((double)Mth.lerp((double)(distanceSquared / (double)this.attackRadiusSqr), (double)5.0, (double)20.0)) : 20;
                    if (i >= timeToShoot) {
                        alchemist.stopUsingItem();
                        ((PiglinAlchemist)((Object)alchemist)).performRangedAttack(target, BowItem.getPowerForTime((int)i));
                        this.attackTime = this.attackIntervalMin;
                    }
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                alchemist.startUsingItem(ProjectileUtil.getWeaponHoldingHand(alchemist, item -> item instanceof BowItem));
            }
            if (distanceSquared > (double)this.attackRadiusSqr && this.seeTime >= 20) {
                this.path = alchemist.getNavigation().createPath((Entity)target, 0);
                alchemist.getNavigation().moveTo(this.path, this.speedModifier);
            } else if (distanceSquared < (double)this.attackRadiusSqr && this.seeTime >= 20) {
                alchemist.getNavigation().stop();
            }
            if (canSee != seeTimeGreaterThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (distanceSquared <= 6.0 || ((PiglinAlchemist)((Object)alchemist)).getArrowsShot() >= 3) {
                if (this.getTargetToShootAt((PiglinAlchemist)((Object)alchemist)) instanceof AbstractPiglin) {
                    return;
                }
                this.avoidTime = this.avoidTime <= 0 ? 60 : (this.avoidTime -= 10);
                if (((PiglinAlchemist)((Object)alchemist)).getArrowsShot() >= 3) {
                    ((PiglinAlchemist)((Object)alchemist)).setArrowsShot(0);
                }
            }
            if (this.avoidTime == 0) {
                alchemist.getNavigation().stop();
            }
            if (this.avoidTime < 0) {
                this.avoidTime = 0;
            }
            if (this.avoidTime > 60) {
                this.avoidTime = 60;
            }
            if (--this.avoidTime > 0) {
                Vec3 vec3 = this.getPosition((PiglinAlchemist)((Object)alchemist));
                if (distanceSquared <= (double)this.attackRadiusSqr && vec3 != null && alchemist.getNavigation().isDone()) {
                    this.path = alchemist.getNavigation().createPath(vec3.x, vec3.y, vec3.z, 0);
                    alchemist.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(new BlockPos((int)vec3.x, (int)alchemist.getEyeY(), (int)vec3.z)));
                    if (this.path != null && this.path.canReach()) {
                        alchemist.getNavigation().moveTo(this.path, this.speedModifier);
                        this.attackTime = -1;
                        alchemist.stopUsingItem();
                    }
                }
            }
        }
    }

    protected void stop(ServerLevel level, E alchemist, long gameTime) {
        alchemist.setAggressive(false);
        this.seeTime = 0;
        this.attackTime = -1;
        alchemist.stopUsingItem();
    }

    @Nullable
    protected Vec3 getPosition(PiglinAlchemist alchemist) {
        if (this.getTargetToShootAt(alchemist) != null) {
            return LandRandomPos.getPosAway((PathfinderMob)alchemist, (int)5, (int)7, (Vec3)this.getTargetToShootAt(alchemist).position());
        }
        return LandRandomPos.getPos((PathfinderMob)alchemist, (int)5, (int)7);
    }

    protected LivingEntity getTargetToShootAt(PiglinAlchemist alchemist) {
        return alchemist.getTarget();
    }
}

