/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import tallestred.piglinproliferation.PPMemoryModules;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;
import tallestred.piglinproliferation.util.CodeUtilities;

public class BaseThrowPotion<E extends PiglinAlchemist>
extends Behavior<E> {
    protected final ItemStack itemToUse;
    protected final Predicate<PiglinAlchemist> canUseSelector;
    protected ItemStack potionToThrow;
    protected int ticksUntilThrow;
    protected int panicTicks;

    public BaseThrowPotion(ItemStack stack, Predicate<PiglinAlchemist> pCanUseSelector) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.REGISTERED));
        this.itemToUse = stack;
        this.canUseSelector = pCanUseSelector;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E alchemist) {
        for (int slot = 0; slot < ((PiglinAlchemist)((Object)alchemist)).beltInventory.size(); ++slot) {
            ItemStack stackInSlot = ((PiglinAlchemist)((Object)alchemist)).beltInventory.get(slot);
            if (!stackInSlot.is(this.itemToUse.getItem()) || !CodeUtilities.compareOptionalHolders(CodeUtilities.potionContents(this.itemToUse).potion(), CodeUtilities.potionContents(stackInSlot).potion())) continue;
            this.potionToThrow = stackInSlot;
            return this.canUseSelector.test((PiglinAlchemist)((Object)alchemist));
        }
        return false;
    }

    protected void start(ServerLevel level, E alchemist, long gameTime) {
        for (int slot = 0; slot < ((PiglinAlchemist)((Object)alchemist)).beltInventory.size(); ++slot) {
            ItemStack stackInSlot = ((PiglinAlchemist)((Object)alchemist)).beltInventory.get(slot);
            if (((PiglinAlchemist)((Object)alchemist)).isGonnaThrowPotion() || !stackInSlot.is(this.itemToUse.getItem()) || !CodeUtilities.compareOptionalHolders(CodeUtilities.potionContents(this.itemToUse).potion(), CodeUtilities.potionContents(stackInSlot).potion()) || !this.canUseSelector.test((PiglinAlchemist)((Object)alchemist))) continue;
            this.potionToThrow = stackInSlot;
            ((PiglinAlchemist)((Object)alchemist)).beltInventory.set(slot, ItemStack.EMPTY);
            alchemist.swing(InteractionHand.OFF_HAND);
            ((PiglinAlchemist)((Object)alchemist)).setItemShownOnOffhand(stackInSlot.copy());
            ((PiglinAlchemist)((Object)alchemist)).getItemShownOnOffhand().set(DataComponents.POTION_CONTENTS, (Object)((PotionContents)stackInSlot.get(DataComponents.POTION_CONTENTS)));
            ((PiglinAlchemist)((Object)alchemist)).willThrowPotion(true);
        }
    }

    protected void throwPotion(E alchemist) {
        if (!((PiglinAlchemist)((Object)alchemist)).getItemShownOnOffhand().isEmpty()) {
            alchemist.swing(InteractionHand.OFF_HAND);
            ((PiglinAlchemist)((Object)alchemist)).throwPotion(((PiglinAlchemist)((Object)alchemist)).getItemShownOnOffhand(), alchemist.getXRot(), alchemist.getYRot());
        }
    }

    protected void stop(ServerLevel level, E alchemist, long gameTime) {
        if (((PiglinAlchemist)((Object)alchemist)).isGonnaThrowPotion() && ((PiglinAlchemist)((Object)alchemist)).getItemShownOnOffhand() != null) {
            ((PiglinAlchemist)((Object)alchemist)).willThrowPotion(false);
            for (int slot = 0; slot < ((PiglinAlchemist)((Object)alchemist)).beltInventory.size(); ++slot) {
                ItemStack stackInSlot = ((PiglinAlchemist)((Object)alchemist)).beltInventory.get(slot);
                if (!stackInSlot.isEmpty()) continue;
                ((PiglinAlchemist)((Object)alchemist)).beltInventory.set(slot, ((PiglinAlchemist)((Object)alchemist)).getItemShownOnOffhand().copy());
                ((PiglinAlchemist)((Object)alchemist)).setItemShownOnOffhand(ItemStack.EMPTY);
            }
        }
    }
}

