/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BackUpIfTooClose;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DismountOrSkipMounting;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.Mount;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StartCelebratingIfTargetDead;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.TriggerGate;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.monster.piglin.RememberIfHoglinWasKilled;
import net.minecraft.world.entity.monster.piglin.StartAdmiringItemIfSeen;
import net.minecraft.world.entity.monster.piglin.StartHuntingHoglin;
import net.minecraft.world.entity.monster.piglin.StopHoldingItemIfNoLongerAdmiring;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import tallestred.piglinproliferation.PPActivities;
import tallestred.piglinproliferation.common.entities.ai.behaviors.SafeCrossbowAttack;
import tallestred.piglinproliferation.common.entities.ai.behaviors.SwimOnlyOutOfLava;
import tallestred.piglinproliferation.util.CodeUtilities;

public abstract class AbstractPiglinAi<P extends Piglin>
extends PiglinAi {
    public Brain<?> populateBrain(P piglin, Brain<P> brain) {
        this.initActivities(piglin, brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public void initActivities(P piglin, Brain<P> brain) {
        this.setupIdleActivity(brain, piglin);
        this.setupCoreActivity(brain, piglin);
        try {
            Brain<P> piglinBrain = brain;
            PiglinAi.initAdmireItemActivity(piglinBrain);
            this.setupFightActivity(brain, piglin);
            PiglinAi.initCelebrateActivity(piglinBrain);
            PiglinAi.initRetreatActivity(piglinBrain);
            this.setupRideHoglinActivity(piglinBrain);
        }
        catch (ClassCastException e) {
            System.out.println("Something went wrong with PiglinAi casts - report to the Piglin Proliferation github.");
            throw e;
        }
    }

    public void setupRideHoglinActivity(Brain<Piglin> pBrain) {
        pBrain.addActivityAndRemoveMemoryWhenStopped(Activity.RIDE, 10, ImmutableList.of((Object)Mount.create((float)0.8f), (Object)SetEntityLookTarget.create(PiglinAi::isPlayerHoldingLovedItem, (float)8.0f), (Object)BehaviorBuilder.sequence((Trigger)BehaviorBuilder.triggerIf(Entity::isPassenger), (Trigger)TriggerGate.triggerOneShuffled((List)((List)CodeUtilities.castOrThrow(ImmutableList.builder().addAll(this.lookBehaviors()).add((Object)Pair.of((Object)BehaviorBuilder.triggerIf(p_258950_ -> true), (Object)1)).build())))), (Object)DismountOrSkipMounting.create((int)8, PiglinAi::wantsToStopRiding)), MemoryModuleType.RIDE_TARGET);
    }

    private void setupCoreActivity(Brain<P> brain, P piglin) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.copyOf(this.coreBehaviors(piglin)));
    }

    private void setupIdleActivity(Brain<P> pBrain, P piglin) {
        pBrain.addActivity(Activity.IDLE, 10, ImmutableList.copyOf(this.idleBehaviors(piglin)));
    }

    private void setupFightActivity(Brain<P> brain, P piglin) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.copyOf(this.fightBehaviors(piglin)), MemoryModuleType.ATTACK_TARGET);
    }

    protected List<BehaviorControl<? super P>> coreBehaviors(P piglin) {
        return CodeUtilities.castElementsToList(new Object[]{new LookAtTargetSink(45, 90), new MoveToTargetSink(), InteractWithDoor.create(), new SwimOnlyOutOfLava(0.8f), PiglinAi.avoidZombified(), StopHoldingItemIfNoLongerAdmiring.create(), StartAdmiringItemIfSeen.create((int)120), StartCelebratingIfTargetDead.create((int)300, PiglinAi::wantsToDance), StopBeingAngryIfTargetDead.create()});
    }

    protected List<BehaviorControl<? super P>> idleBehaviors(P piglin) {
        return CodeUtilities.castElementsToList(SetEntityLookTarget.create(PiglinAi::isPlayerHoldingLovedItem, (float)14.0f), StartAttacking.create(AbstractPiglin::isAdult, this::nearestValidAttackTarget), BehaviorBuilder.triggerIf(Piglin::canHunt, (OneShot)StartHuntingHoglin.create()), PiglinAi.avoidRepellent(), PiglinAi.babySometimesRideBabyHoglin(), this.idleLookBehaviors(), this.idleMovementBehaviors(), SetLookAndInteract.create((EntityType)EntityType.PLAYER, (int)4));
    }

    protected ImmutableList<Pair<OneShot<LivingEntity>, Integer>> lookBehaviors() {
        return PiglinAi.createLookBehaviors();
    }

    protected RunOne<LivingEntity> idleLookBehaviors() {
        return PiglinAi.createIdleLookBehaviors();
    }

    protected RunOne<P> idleMovementBehaviors() {
        return (RunOne)CodeUtilities.castOrThrow(PiglinAi.createIdleMovementBehaviors());
    }

    protected List<BehaviorControl<? super P>> fightBehaviors(P piglin) {
        return CodeUtilities.castElementsToList(new Object[]{StopAttackingIfTargetInvalid.create(entity -> !this.isEntityValidForAttack(piglin, (LivingEntity)entity)), BehaviorBuilder.triggerIf(PiglinAi::hasCrossbow, (OneShot)BackUpIfTooClose.create((int)5, (float)0.75f)), SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f), MeleeAttack.create((int)20), new SafeCrossbowAttack(), RememberIfHoglinWasKilled.create(), EraseMemoryIf.create(PiglinAi::isNearZombified, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET)});
    }

    private boolean isEntityValidForAttack(P piglin, LivingEntity target) {
        return this.nearestValidAttackTarget((Piglin)piglin).filter(p_34887_ -> p_34887_ == target).isPresent();
    }

    protected Optional<? extends LivingEntity> nearestValidAttackTarget(Piglin piglin) {
        return PiglinAi.findNearestValidAttackTarget((Piglin)piglin);
    }

    public static Optional<? extends LivingEntity> findNemesisTarget(Brain<? extends Piglin> brain) {
        Optional optional;
        if (brain.hasMemoryValue(MemoryModuleType.UNIVERSAL_ANGER) && (optional = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER)).isPresent()) {
            return optional;
        }
        optional = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS);
        return optional;
    }

    public void stopHoldingOffHandItem(P piglin, boolean barter, ResourceKey<LootTable> lootTableLocation) {
        ItemStack stack = piglin.getItemInHand(InteractionHand.OFF_HAND);
        piglin.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        if (piglin.isAdult()) {
            boolean flag1;
            boolean stackIsPiglinCurrency = stack.isPiglinCurrency();
            if (barter && stackIsPiglinCurrency) {
                MinecraftServer server = piglin.level().getServer();
                if (server != null) {
                    this.throwItems(piglin, (List<ItemStack>)server.reloadableRegistries().getLootTable(lootTableLocation).getRandomItems(new LootParams.Builder((ServerLevel)piglin.level()).withParameter(LootContextParams.ORIGIN, (Object)piglin.position()).withParameter(LootContextParams.THIS_ENTITY, piglin).create(LootContextParamSets.PIGLIN_BARTER)));
                }
            } else if (!stackIsPiglinCurrency && !(flag1 = piglin.equipItemIfPossible(stack).isEmpty())) {
                this.putInInventory(piglin, stack);
            }
        } else {
            boolean flag2 = piglin.equipItemIfPossible(stack).isEmpty();
            if (!flag2) {
                ItemStack itemstack1 = piglin.getMainHandItem();
                if (AbstractPiglinAi.isLovedItem((ItemStack)itemstack1)) {
                    this.putInInventory(piglin, itemstack1);
                } else {
                    this.throwItems(piglin, Collections.singletonList(itemstack1));
                }
                piglin.setItemSlot(EquipmentSlot.MAINHAND, stack);
                piglin.setGuaranteedDrop(EquipmentSlot.MAINHAND);
                piglin.setPersistenceRequired();
            }
        }
    }

    protected void putInInventory(P piglin, ItemStack toAdd) {
        ItemStack added = piglin.getInventory().addItem(toAdd);
        this.throwItemsTowardRandomPos(piglin, Collections.singletonList(added));
    }

    public void throwItems(P piglin, List<ItemStack> stacks) {
        Optional optional = piglin.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER);
        if (optional.isPresent()) {
            this.throwItemsTowardPlayer(piglin, (Player)optional.get(), stacks);
        } else {
            this.throwItemsTowardRandomPos(piglin, stacks);
        }
    }

    public void throwItemsTowardRandomPos(P piglin, List<ItemStack> stacks) {
        this.throwItemsTowardPos(piglin, stacks, AbstractPiglinAi.getRandomNearbyPos(piglin));
    }

    protected void throwItemsTowardPlayer(P piglin, Player player, List<ItemStack> stacks) {
        this.throwItemsTowardPos(piglin, stacks, player.position());
    }

    protected void throwItemsTowardPos(P piglin, List<ItemStack> stacks, Vec3 pos) {
        if (!stacks.isEmpty()) {
            piglin.swing(InteractionHand.OFF_HAND);
            for (ItemStack stack : stacks) {
                this.specificThrowItemBehaviour(piglin, stack);
                BehaviorUtils.throwItem(piglin, (ItemStack)stack, (Vec3)pos.add(0.0, 1.0, 0.0));
            }
        }
    }

    protected void specificThrowItemBehaviour(P piglin, ItemStack stack) {
    }

    public void updateBrainActivity(P piglin) {
        Brain brain = piglin.getBrain();
        Activity activity = brain.getActiveNonCoreActivity().orElse(null);
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)((Activity)PPActivities.THROW_POTION_ACTIVITY.get()), (Object)Activity.ADMIRE_ITEM, (Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.CELEBRATE, (Object)Activity.RIDE, (Object)Activity.IDLE));
        Activity activity1 = brain.getActiveNonCoreActivity().orElse(null);
        if (activity != activity1) {
            this.soundForCurrentActivity(piglin).ifPresent(arg_0 -> piglin.playSound(arg_0));
        }
        piglin.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
        if (!brain.hasMemoryValue(MemoryModuleType.RIDE_TARGET) && AbstractPiglinAi.isBabyRidingBaby(piglin)) {
            piglin.stopRiding();
        }
        if (!brain.hasMemoryValue(MemoryModuleType.CELEBRATE_LOCATION)) {
            brain.eraseMemory(MemoryModuleType.DANCING);
        }
        piglin.setDancing(brain.hasMemoryValue(MemoryModuleType.DANCING));
    }

    public Optional<SoundEvent> soundForCurrentActivity(P piglin) {
        return piglin.getBrain().getActiveNonCoreActivity().map(activity -> this.soundForActivity(piglin, (Activity)activity));
    }

    public abstract SoundEvent soundForActivity(P var1, Activity var2);
}

