/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import tallestred.piglinproliferation.PPMemoryModules;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.blocks.PiglinSkullBlock;
import tallestred.piglinproliferation.common.entities.ai.PiglinAlchemistAi;
import tallestred.piglinproliferation.common.items.PPItems;
import tallestred.piglinproliferation.configuration.PPConfig;
import tallestred.piglinproliferation.util.CodeUtilities;

public class PiglinAlchemist
extends Piglin {
    protected static final EntityDataAccessor<Boolean> IS_ABOUT_TO_THROW_POTION = SynchedEntityData.defineId(PiglinAlchemist.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<ItemStack> ITEM_SHOWN_ON_OFFHAND = SynchedEntityData.defineId(PiglinAlchemist.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    protected static final EntityDataAccessor<ItemStack>[] BELT_INVENTORY_SLOTS = PiglinAlchemist.defineBeltInventory(6);
    public final BeltInventory beltInventory = new BeltInventory();
    protected int arrowsShot;

    public PiglinAlchemist(EntityType<? extends PiglinAlchemist> type, Level level) {
        super(type, level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Piglin.createAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    public static boolean checkChemistSpawnRules(EntityType<PiglinAlchemist> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return !levelAccessor.getBlockState(blockPos.below()).is(Blocks.NETHER_WART_BLOCK);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)PPSounds.ALCHEMIST_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)PPSounds.ALCHEMIST_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)PPSounds.ALCHEMIST_DEATH.get();
    }

    protected void populateDefaultEquipmentSlots(RandomSource source, DifficultyInstance pDifficulty) {
        super.populateDefaultEquipmentSlots(source, pDifficulty);
        if (this.isAdult()) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
            if (source.nextFloat() < ((Double)PPConfig.COMMON.healingArrowChances.get()).floatValue()) {
                ItemStack tippedArrow = PotionContents.createItemStack((Item)Items.TIPPED_ARROW, (Holder)Potions.STRONG_HEALING);
                tippedArrow.setCount(source.nextInt(((Integer)PPConfig.COMMON.healingArrowMinStackSize.get()).intValue(), ((Integer)PPConfig.COMMON.healingArrowMaxStackSize.get()).intValue()));
                this.beltInventory.set(source.nextInt(6), tippedArrow);
            }
            for (int slot = 0; slot < this.beltInventory.size(); ++slot) {
                if (!this.beltInventory.get(slot).isEmpty()) continue;
                Holder potion = source.nextFloat() < 0.35f ? Potions.FIRE_RESISTANCE : (source.nextFloat() < 0.3f ? Potions.STRONG_REGENERATION : (source.nextFloat() < 0.25f ? Potions.STRONG_HEALING : Potions.STRONG_STRENGTH));
                this.beltInventory.set(slot, PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)potion));
            }
        }
    }

    protected void playStepSound(BlockPos p_32159_, BlockState p_32160_) {
        if (this.getRandom().nextInt(20) == 0 && this.beltInventory.anyMatch(stack -> stack.getItem() instanceof PotionItem)) {
            this.playSound((SoundEvent)PPSounds.ALCHEMIST_WALK.get(), 0.5f * ((float)this.beltInventory.countMatches(stack -> stack.getItem() instanceof PotionItem) * 0.5f), 1.0f);
        }
        this.playSound((SoundEvent)PPSounds.ALCHEMIST_STEP.get(), 0.15f, 1.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_ABOUT_TO_THROW_POTION, (Object)false);
        builder.define(ITEM_SHOWN_ON_OFFHAND, (Object)ItemStack.EMPTY);
        for (EntityDataAccessor<ItemStack> accessor : BELT_INVENTORY_SLOTS) {
            builder.define(accessor, (Object)ItemStack.EMPTY);
        }
    }

    protected void onEffectAdded(MobEffectInstance mobEffect, @Nullable Entity entity) {
        if (mobEffect.getEffect() == MobEffects.FIRE_RESISTANCE) {
            this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
            this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
            this.setPathfindingMalus(PathType.LAVA, 0.0f);
        }
        super.onEffectAdded(mobEffect, entity);
    }

    protected void onEffectRemoved(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.getEffect() == MobEffects.FIRE_RESISTANCE) {
            this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
            this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
            this.setPathfindingMalus(PathType.LAVA, -1.0f);
        }
        super.onEffectRemoved(mobEffectInstance);
    }

    public boolean isGonnaThrowPotion() {
        return (Boolean)this.entityData.get(IS_ABOUT_TO_THROW_POTION);
    }

    protected void customServerAiStep() {
        this.timeInOverworld = this.isConverting() ? ++this.timeInOverworld : 0;
        if (this.timeInOverworld > 300 && EventHooks.canLivingConvert((LivingEntity)this, (EntityType)EntityType.ZOMBIFIED_PIGLIN, timer -> {
            this.timeInOverworld = timer;
        })) {
            this.playConvertedSound();
            this.finishConversion((ServerLevel)this.level());
        }
        this.level().getProfiler().push("piglinBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        PiglinAlchemistAi.INSTANCE.updateBrainActivity(this);
    }

    protected void playConvertedSound() {
        this.playSound((SoundEvent)PPSounds.ALCHEMIST_CONVERTED.get(), this.getSoundVolume(), this.getVoicePitch() / 0.1f);
    }

    public boolean canHunt() {
        return super.canHunt();
    }

    public void willThrowPotion(boolean throwPotion) {
        this.entityData.set(IS_ABOUT_TO_THROW_POTION, (Object)throwPotion);
    }

    public ItemStack getItemShownOnOffhand() {
        return (ItemStack)this.entityData.get(ITEM_SHOWN_ON_OFFHAND);
    }

    public void setItemShownOnOffhand(ItemStack itemShownOnOffhand) {
        this.entityData.set(ITEM_SHOWN_ON_OFFHAND, (Object)itemShownOnOffhand);
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource source, boolean recentlyHitIn) {
        for (ItemStack itemStack : this.beltInventory.values()) {
            if (itemStack.isEmpty()) continue;
            if (!EnchantmentHelper.has((ItemStack)itemStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) && (double)this.getRandom().nextFloat() < (Double)PPConfig.COMMON.alchemistPotionChance.get()) {
                this.spawnAtLocation(itemStack);
                continue;
            }
            if (!(itemStack.getItem() instanceof PotionItem)) continue;
            for (int i = 0; i < 5; ++i) {
                BlockPos blockpos = this.blockPosition();
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemStack), (double)blockpos.getX() + this.level().random.nextDouble(), (double)(blockpos.getY() + 1), (double)blockpos.getZ() + this.level().random.nextDouble(), 0, 0.0, 0.0, 0.0, 0.0);
            }
            this.playSound(SoundEvents.SPLASH_POTION_BREAK, 0.5f, 1.0f);
        }
        PiglinSkullBlock.spawnSkullIfValidKill(source, (Entity)this, e -> (Item)PPItems.PIGLIN_ALCHEMIST_HEAD_ITEM.get());
        this.beltInventory.clear();
        super.dropCustomDeathLoot(level, source, recentlyHitIn);
    }

    public void throwPotion(ItemStack thrownPotion, float xRot, float yRot) {
        ThrownPotion thrownpotion = new ThrownPotion(this.level(), (LivingEntity)this);
        thrownpotion.setItem(thrownPotion);
        thrownpotion.shootFromRotation((Entity)this, xRot, yRot, -20.0f, 0.5f, 1.0f);
        if (!this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.SPLASH_POTION_THROW, this.getSoundSource(), 1.0f, 0.8f + this.getRandom().nextFloat() * 0.4f);
        }
        this.level().addFreshEntity((Entity)thrownpotion);
        this.willThrowPotion(false);
        thrownPotion.shrink(1);
    }

    protected Brain.Provider<PiglinAlchemist> alchemistBrainProvider() {
        ArrayList<MemoryModuleType> ALCHEMIST_MEMORY_TYPES = new ArrayList<MemoryModuleType>((Collection<MemoryModuleType>)Piglin.MEMORY_TYPES);
        ALCHEMIST_MEMORY_TYPES.add((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get());
        return Brain.provider((Collection)ImmutableList.copyOf(ALCHEMIST_MEMORY_TYPES), (Collection)SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return PiglinAlchemistAi.INSTANCE.populateBrain(this, this.alchemistBrainProvider().makeBrain(dynamic));
    }

    public boolean isBaby() {
        return false;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.getMainHandItem().getItem() instanceof CrossbowItem) {
            super.performRangedAttack(target, distanceFactor);
        }
        if (this.getMainHandItem().getItem() instanceof BowItem) {
            ItemStack itemstack = this.getProjectile(this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
            for (int slot = 0; slot < this.beltInventory.size() && !(this.getItemShownOnOffhand().getItem() instanceof TippedArrowItem); ++slot) {
                if (!(this.beltInventory.get(slot).getItem() instanceof TippedArrowItem)) continue;
                ItemStack tippedArrow = this.beltInventory.get(slot);
                Iterable effectInstanceList = CodeUtilities.potionContents(tippedArrow).getAllEffects();
                if ((this.getTarget() == null || target != this.getTarget() || !this.anyEffectsMatch(effectInstanceList, instance -> !((MobEffect)instance.getEffect().value()).isBeneficial())) && target == this.getTarget() && (this.getTarget() == null || !this.getTarget().isInvertedHealAndHarm() || !this.anyEffectsMatch(effectInstanceList, instance -> instance.getEffect() == MobEffects.HEAL))) continue;
                this.setItemShownOnOffhand(tippedArrow.copy());
                this.beltInventory.set(slot, ItemStack.EMPTY);
            }
            if (this.getItemShownOnOffhand().getItem() instanceof TippedArrowItem) {
                itemstack = this.getItemShownOnOffhand();
            }
            AbstractArrow abstractarrowentity = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor, (ItemStack)this.getMainHandItem());
            abstractarrowentity = ((BowItem)this.getMainHandItem().getItem()).customArrow(abstractarrowentity, itemstack, this.getMainHandItem());
            double d0 = target.getX() - this.getX();
            double d1 = target.getY(0.3333333333333333) - abstractarrowentity.getY();
            double d2 = target.getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            abstractarrowentity.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
            this.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)abstractarrowentity);
            this.setArrowsShot(this.getArrowsShot() + 1);
            itemstack.shrink(1);
            if (itemstack.isEmpty() && this.getItemShownOnOffhand().is(itemstack.getItem())) {
                this.setItemShownOnOffhand(ItemStack.EMPTY);
            }
        }
    }

    private boolean anyEffectsMatch(Iterable<MobEffectInstance> effectInstances, Predicate<MobEffectInstance> condition) {
        for (MobEffectInstance effectInstance : effectInstances) {
            if (!condition.test(effectInstance)) continue;
            return true;
        }
        return false;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.beltInventory.values(), (HolderLookup.Provider)this.registryAccess());
        tag.putInt("ArrowsShot", this.getArrowsShot());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        NonNullList readItems = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)readItems, (HolderLookup.Provider)this.registryAccess());
        for (int i = 0; i < readItems.size(); ++i) {
            this.beltInventory.set(i, (ItemStack)readItems.get(i));
        }
        this.setArrowsShot(tag.getInt("ArrowsShot"));
    }

    public int getArrowsShot() {
        return this.arrowsShot;
    }

    public void setArrowsShot(int arrowsShot) {
        this.arrowsShot = arrowsShot;
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem item) {
        return item instanceof BowItem || super.canFireProjectileWeapon(item);
    }

    public static EntityDataAccessor<ItemStack>[] defineBeltInventory(int capacity) {
        EntityDataAccessor[] slots = new EntityDataAccessor[capacity];
        for (int i = 0; i < capacity; ++i) {
            slots[i] = SynchedEntityData.defineId(PiglinAlchemist.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
        }
        return slots;
    }

    public class BeltInventory {
        public NonNullList<ItemStack> values() {
            NonNullList items = NonNullList.withSize((int)this.size(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < this.size(); ++i) {
                items.set(i, (Object)((ItemStack)PiglinAlchemist.this.entityData.get(BELT_INVENTORY_SLOTS[i])));
            }
            return items;
        }

        public int size() {
            return BELT_INVENTORY_SLOTS.length;
        }

        public void clear() {
            for (int i = 0; i < this.size(); ++i) {
                PiglinAlchemist.this.entityData.set(BELT_INVENTORY_SLOTS[i], (Object)ItemStack.EMPTY);
            }
        }

        public ItemStack get(int slot) {
            return (ItemStack)PiglinAlchemist.this.entityData.get(BELT_INVENTORY_SLOTS[slot]);
        }

        public void set(int slot, ItemStack stack) {
            PiglinAlchemist.this.entityData.set(BELT_INVENTORY_SLOTS[slot], (Object)stack);
        }

        public boolean anyMatch(Predicate<ItemStack> predicate) {
            for (EntityDataAccessor<ItemStack> accessor : BELT_INVENTORY_SLOTS) {
                if (!predicate.test((ItemStack)PiglinAlchemist.this.entityData.get(accessor))) continue;
                return true;
            }
            return false;
        }

        public boolean noneMatch(Predicate<ItemStack> predicate) {
            for (EntityDataAccessor<ItemStack> accessor : BELT_INVENTORY_SLOTS) {
                if (!predicate.test((ItemStack)PiglinAlchemist.this.entityData.get(accessor))) continue;
                return false;
            }
            return true;
        }

        public int countMatches(Predicate<ItemStack> predicate) {
            int count = 0;
            for (EntityDataAccessor<ItemStack> accessor : BELT_INVENTORY_SLOTS) {
                if (!predicate.test((ItemStack)PiglinAlchemist.this.entityData.get(accessor))) continue;
                ++count;
            }
            return count;
        }

        public List<ItemStack> getMatches(Predicate<ItemStack> predicate) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (EntityDataAccessor<ItemStack> accessor : BELT_INVENTORY_SLOTS) {
                ItemStack stack = (ItemStack)PiglinAlchemist.this.entityData.get(accessor);
                if (!predicate.test(stack)) continue;
                items.add(stack);
            }
            return items;
        }
    }
}

