/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.blocks;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tallestred.piglinproliferation.common.blockentities.FireRingBlockEntity;
import tallestred.piglinproliferation.common.blockentities.PPBlockEntities;
import tallestred.piglinproliferation.util.CodeUtilities;

public class FireRingBlock
extends CampfireBlock {
    public static final BooleanProperty BREWING = BooleanProperty.create((String)"brewing");
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    protected final int effectApplyTime;

    public FireRingBlock(boolean spawnParticles, int fireDamage, int effectApplyTime, BlockBehaviour.Properties properties) {
        super(spawnParticles, fireDamage, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BREWING, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.effectApplyTime = effectApplyTime;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FireRingBlockEntity(pos, state);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FireRingBlockEntity) {
            FireRingBlockEntity blockEntity2 = (FireRingBlockEntity)blockEntity;
            Optional optional = blockEntity2.getCookableRecipe(stack);
            if (optional.isPresent()) {
                if (!level.isClientSide && blockEntity2.placeFood((LivingEntity)player, player.getAbilities().instabuild ? stack.copy() : stack, 2 * ((CampfireCookingRecipe)((RecipeHolder)optional.get()).value()).getCookingTime())) {
                    player.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.CONSUME;
            }
            if (stack.getItem() == Items.POTION && blockEntity2.addEffects(player, hand, stack, CodeUtilities.potionContents(stack))) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            state.setValue((Property)BREWING, (Comparable)Boolean.valueOf(false));
            state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return (Boolean)state.getValue((Property)LIT) != false ? FireRingBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)PPBlockEntities.FIRE_RING.get()), FireRingBlockEntity::particleTick) : null;
        }
        return (Boolean)state.getValue((Property)LIT) != false ? FireRingBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)PPBlockEntities.FIRE_RING.get()), (lvl, pos, st, be) -> FireRingBlockEntity.cookTick(lvl, pos, st, be, this.effectApplyTime)) : FireRingBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)PPBlockEntities.FIRE_RING.get()), FireRingBlockEntity::cooldownTick);
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hitResult, Projectile projectile) {
        super.onProjectileHit(level, state, hitResult, projectile);
        BlockEntity blockEntity = level.getBlockEntity(hitResult.getBlockPos());
        if (blockEntity instanceof FireRingBlockEntity) {
            FireRingBlockEntity blockEntity2 = (FireRingBlockEntity)blockEntity;
            if (projectile instanceof ThrownPotion) {
                ThrownPotion potion = (ThrownPotion)projectile;
                blockEntity2.addEffects(CodeUtilities.castOrNull(projectile.getOwner(), Player.class), null, null, CodeUtilities.potionContents(potion.getItem()));
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, SIGNAL_FIRE, WATERLOGGED, FACING, BREWING});
    }
}

