/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.attribute;

import net.minecraft.core.Holder;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import tallestred.piglinproliferation.common.attribute.AbstractAttributeModifierHolder;

public class AttributeModifierHolder
extends AbstractAttributeModifierHolder {
    public final double defaultAmount;
    public final AttributeModifier.Operation defaultOperation;
    protected final Instance defaultInstance;

    public AttributeModifierHolder(Holder<Attribute> attribute, String name, double defaultAmount, AttributeModifier.Operation defaultOperation) {
        super(attribute, name);
        this.defaultAmount = defaultAmount;
        this.defaultOperation = defaultOperation;
        this.defaultInstance = new Instance(this, defaultAmount, defaultOperation);
    }

    @Override
    public Instance get() {
        return this.defaultInstance;
    }

    @Override
    public Instance getWithMultiplier(double multiplier) {
        return new Instance(this, this.defaultAmount * multiplier, this.defaultOperation);
    }

    @Override
    public Instance getWithSummand(double summand) {
        return new Instance(this, this.defaultAmount + summand, this.defaultOperation);
    }

    public Instance getWithNewAmount(double newAmount) {
        return new Instance(this, newAmount, this.defaultOperation);
    }

    public Instance getWithNewAmountAndOperation(double newAmount, AttributeModifier.Operation operation) {
        return new Instance(this, newAmount, operation);
    }

    public class Instance
    extends AbstractAttributeModifierHolder.Instance {
        public AttributeModifier modifier;

        protected Instance(AttributeModifierHolder this$0, double amount, AttributeModifier.Operation operation) {
            super(this$0);
            this.modifier = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"piglinproliferation", (String)this$0.name), amount, operation);
        }

        @Override
        public void addTransientModifier(LivingEntity entity) {
            this.addTransientInternal(this.modifier, entity);
        }

        @Override
        public void addPermanentModifier(LivingEntity entity) {
            this.addPermanentInternal(this.modifier, entity);
        }

        @Override
        public MutableComponent translatable() {
            return this.translatableInternal(this.modifier.amount(), this.modifier.operation(), false, -1.0);
        }

        @Override
        public MutableComponent translatable(double baseAmount) {
            return this.translatableInternal(this.modifier.amount(), this.modifier.operation(), true, baseAmount);
        }
    }
}

