/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.client.renderers.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import tallestred.piglinproliferation.capablities.PPDataAttachments;
import tallestred.piglinproliferation.client.renderers.PPRenderSetupEvents;
import tallestred.piglinproliferation.configuration.PPConfig;

public class PiglinClothingRenderLayer<T extends ZombifiedPiglin, M extends PiglinModel<T>>
extends RenderLayer<T, M> {
    private final PiglinModel<T> layerModel = new PiglinModel(Minecraft.getInstance().getEntityModels().bakeLayer(PPRenderSetupEvents.ZIGLIN_CLOTHING));

    public PiglinClothingRenderLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
        this.layerModel.rightEar.visible = false;
    }

    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (!((Boolean)PPConfig.CLIENT.ziglinTextures.get()).booleanValue()) {
            return;
        }
        if (this.getClothingTexture(pLivingEntity) != null && !((String)pLivingEntity.getData(PPDataAttachments.TRANSFORMATION_TRACKER)).isEmpty()) {
            PiglinClothingRenderLayer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), this.layerModel, (ResourceLocation)this.getClothingTexture(pLivingEntity), (PoseStack)pMatrixStack, (MultiBufferSource)pBuffer, (int)pPackedLight, pLivingEntity, (float)pLimbSwing, (float)pLimbSwingAmount, (float)pAgeInTicks, (float)pNetHeadYaw, (float)pHeadPitch, (float)pPartialTicks, (int)-1);
        }
    }

    protected ResourceLocation getClothingTexture(T livingEntity) {
        String texture = "textures/entity/piglin/clothing_" + (String)livingEntity.getData(PPDataAttachments.TRANSFORMATION_TRACKER) + ".png";
        return ResourceLocation.fromNamespaceAndPath((String)"piglinproliferation", (String)texture);
    }
}

