/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.client.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import tallestred.piglinproliferation.configuration.PPConfig;
import tallestred.piglinproliferation.mixins.LivingEntityRendererInvoker;

public class AfterImageParticle
extends Particle {
    private int life;
    private final LivingEntity entity;

    public AfterImageParticle(LivingEntity entity, ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.entity = entity;
    }

    public void render(@NotNull VertexConsumer vertex, Camera camera, float tick) {
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 vec3 = camera.getPosition();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f / Math.abs((float)this.life + 1.0f)));
        PoseStack stack = new PoseStack();
        if (((Boolean)PPConfig.CLIENT.RenderAfterImageLayers.get()).booleanValue()) {
            multibuffersource$buffersource.getBuffer(RenderType.entityTranslucent((ResourceLocation)entityRenderDispatcher.getRenderer((Entity)this.entity).getTextureLocation((Entity)this.entity)));
            entityRenderDispatcher.render((Entity)this.entity, this.x - vec3.x(), this.y - vec3.y(), this.z - vec3.z(), this.entity.getYRot(), tick, stack, (MultiBufferSource)multibuffersource$buffersource, entityRenderDispatcher.getPackedLightCoords((Entity)this.entity, tick));
        } else {
            Direction direction;
            Entity entity;
            boolean shouldSit;
            stack.pushPose();
            multibuffersource$buffersource.getBuffer(RenderType.entityTranslucent((ResourceLocation)entityRenderDispatcher.getRenderer((Entity)this.entity).getTextureLocation((Entity)this.entity)));
            LivingEntityRenderer renderer = (LivingEntityRenderer)entityRenderDispatcher.getRenderer((Entity)this.entity);
            EntityModel model = renderer.getModel();
            model.attackTime = this.entity.getAttackAnim(tick);
            model.riding = shouldSit = this.entity.isPassenger() && this.entity.getVehicle() != null && this.entity.getVehicle().shouldRiderSit();
            model.young = this.entity.isBaby();
            float f = Mth.rotLerp((float)tick, (float)this.entity.yBodyRotO, (float)this.entity.yBodyRot);
            float f1 = Mth.rotLerp((float)tick, (float)this.entity.yHeadRotO, (float)this.entity.yHeadRot);
            float f2 = f1 - f;
            stack.translate(this.x - vec3.x(), this.y - vec3.y() + (double)1.4f, this.z - vec3.z());
            if (shouldSit && (entity = this.entity.getVehicle()) instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                f = Mth.rotLerp((float)tick, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
                f2 = f1 - f;
                float f3 = Mth.wrapDegrees((float)f2);
                if (f3 < -85.0f) {
                    f3 = -85.0f;
                }
                if (f3 >= 85.0f) {
                    f3 = 85.0f;
                    f = f1 - f3;
                } else {
                    f = f1 - f3;
                }
                if (f3 * f3 > 2500.0f) {
                    f += f3 * 0.2f;
                }
                f2 = f1 - f;
            }
            float f6 = Mth.lerp((float)tick, (float)this.entity.xRotO, (float)this.entity.getXRot());
            if (this.entity.getPose() == Pose.SLEEPING && (direction = this.entity.getBedOrientation()) != null) {
                float f4 = this.entity.getEyeHeight(Pose.STANDING) - 0.1f;
                stack.translate((double)((float)(-direction.getStepX()) * f4), 0.0, (double)((float)(-direction.getStepZ()) * f4));
            }
            float f7 = (float)this.entity.tickCount + tick;
            stack.mulPose(Axis.YP.rotationDegrees(180.0f - f));
            ((LivingEntityRendererInvoker)renderer).invokeScale(this.entity, stack, tick);
            stack.scale(-1.0f, -1.0f, 1.0f);
            float f8 = 0.0f;
            float f5 = 0.0f;
            if (!shouldSit && this.entity.isAlive()) {
                f8 = this.entity.walkAnimation.speed(tick);
                f5 = this.entity.walkAnimation.position(tick);
                if (this.entity.isBaby()) {
                    f5 *= 3.0f;
                }
                if (f8 > 1.0f) {
                    f8 = 1.0f;
                }
            }
            model.prepareMobModel((Entity)this.entity, f5, f8, tick);
            model.setupAnim((Entity)this.entity, f5, f8, f7, f2, f6);
            Minecraft minecraft = Minecraft.getInstance();
            boolean flag = !this.entity.isInvisible();
            boolean flag1 = !flag && !this.entity.isInvisibleTo((Player)minecraft.player);
            boolean flag2 = minecraft.shouldEntityAppearGlowing((Entity)this.entity);
            RenderType rendertype = AfterImageParticle.getRenderType(this.entity, renderer, model, flag, flag1, flag2);
            if (rendertype != null) {
                VertexConsumer ivertexbuilder = multibuffersource$buffersource.getBuffer(rendertype);
                int overlay = LivingEntityRenderer.getOverlayCoords((LivingEntity)this.entity, (float)0.0f);
                model.renderToBuffer(stack, ivertexbuilder, this.getLightColor(tick), overlay, flag1 ? 0x26FFFFFF : -1);
            }
            stack.popPose();
        }
        multibuffersource$buffersource.endBatch();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static RenderType getRenderType(LivingEntity p_230496_1_, LivingEntityRenderer<LivingEntity, ?> renderer, EntityModel<?> model, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation resourcelocation = renderer.getTextureLocation((Entity)p_230496_1_);
        if (p_230496_3_) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)resourcelocation);
        }
        if (p_230496_2_) {
            return RenderType.entityTranslucent((ResourceLocation)resourcelocation);
        }
        return p_230496_4_ ? RenderType.outline((ResourceLocation)resourcelocation) : null;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void tick() {
        ++this.life;
        if (this.life >= 3) {
            this.remove();
        }
    }
}

