/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.client.models;

import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import tallestred.piglinproliferation.common.entities.PiglinTraveler;

public class PiglinTravelerModel<T extends PiglinTraveler>
extends PiglinModel<T> {
    public final ModelPart jacket;
    public final ModelPart hat_brim;

    public PiglinTravelerModel(ModelPart root) {
        super(root);
        this.jacket = this.body.getChild("jacket");
        this.hat_brim = this.getHead().getChild("hat_brim");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = PiglinModel.createMesh((CubeDeformation)CubeDeformation.NONE);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-24.0f, (float)0.0f));
        body.addOrReplaceChild("jacket", CubeListBuilder.create().texOffs(56, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 24.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(62, 0).addBox(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-24.0f, (float)0.0f));
        head.addOrReplaceChild("hat_brim", CubeListBuilder.create().texOffs(80, 19).addBox(-8.0f, -5.0f, -8.0f, 16.0f, 1.0f, 16.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("hat_big", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, new CubeDeformation(-0.02f)).texOffs(31, 1).addBox(-2.0f, -4.0f, -5.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(2, 4).addBox(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(2, 0).addBox(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)148, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (((PiglinTraveler)((Object)entity)).isSitting()) {
            this.rightArm.xRot += -0.62831855f;
            this.leftArm.xRot += -0.62831855f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        }
        this.hat_brim.visible = entity.getItemBySlot(EquipmentSlot.HEAD).isEmpty();
        this.leftSleeve.copyFrom(this.leftArm);
        this.rightSleeve.copyFrom(this.rightArm);
        if (((PiglinTraveler)((Object)entity)).getKickTicks() > 0) {
            float f1 = 1.0f - (float)Mth.abs((int)(10 - 2 * ((PiglinTraveler)((Object)entity)).getKickTicks())) / 10.0f;
            this.rightLeg.xRot = Mth.lerp((float)f1, (float)this.rightLeg.xRot, (float)-1.4f);
        }
    }
}

