/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.client.models;

import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;

public class PiglinAlchemistModel<T extends PiglinAlchemist>
extends PiglinModel<T> {
    public final ModelPart bodyForLeggings;
    public final ModelPart bodyForChest;
    public final ModelPart belt;
    public final ModelPart leftEar;

    public PiglinAlchemistModel(ModelPart root) {
        super(root);
        this.leftEar = this.head.getChild("left_ear");
        this.bodyForLeggings = this.body.getChild("bodyForLeggings");
        this.bodyForChest = this.body.getChild("bodyForChest");
        this.belt = this.body.getChild("belt");
        this.bodyForLeggings.visible = false;
    }

    public static MeshDefinition createBodyLayer(CubeDeformation bodyDeformation, CubeDeformation bodyDeformation2, CubeDeformation bodyDeformation3) {
        MeshDefinition meshdefinition = PiglinModel.createMesh((CubeDeformation)CubeDeformation.NONE);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("belt", CubeListBuilder.create().texOffs(56, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 24.0f, 4.0f, bodyDeformation), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("bodyForLeggings", CubeListBuilder.create().texOffs(56, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 24.0f, 4.0f, bodyDeformation2), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("bodyForChest", CubeListBuilder.create().texOffs(56, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 24.0f, 4.0f, bodyDeformation3), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(62, 0).addBox(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)).texOffs(0, 0).addBox(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, new CubeDeformation(-0.02f)).texOffs(31, 1).addBox(-2.0f, -4.0f, -5.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(2, 4).addBox(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(2, 0).addBox(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        hat.addOrReplaceChild("googles", CubeListBuilder.create().texOffs(42, 0).addBox(-5.0f, -31.0f, -5.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.1f)).texOffs(52, 0).addBox(1.0f, -31.0f, -5.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return meshdefinition;
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.setupAnim(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        boolean isWearingChestplateOrLeggings = pEntity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ArmorItem || pEntity.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof ArmorItem;
        this.bodyForLeggings.visible = pEntity.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof ArmorItem && !(pEntity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ArmorItem);
        this.bodyForChest.visible = pEntity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ArmorItem;
        boolean bl = this.belt.visible = !isWearingChestplateOrLeggings;
        if (((PiglinAlchemist)((Object)pEntity)).isGonnaThrowPotion()) {
            if (pEntity.isLeftHanded()) {
                this.rightArm.xRot = -1.8f;
            } else {
                this.leftArm.xRot = -1.8f;
            }
        }
        this.leftPants.copyFrom(this.leftLeg);
        this.rightPants.copyFrom(this.rightLeg);
        this.leftSleeve.copyFrom(this.leftArm);
        this.rightSleeve.copyFrom(this.rightArm);
        this.jacket.copyFrom(this.body);
    }
}

