/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.CalculatePlayerTurnEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import tallestred.piglinproliferation.common.attribute.PPAttributes;
import tallestred.piglinproliferation.common.items.BucklerItem;
import tallestred.piglinproliferation.common.items.PPItems;
import tallestred.piglinproliferation.configuration.PPConfig;

@EventBusSubscriber(value={Dist.CLIENT}, modid="piglinproliferation")
public class PPClientEvents {
    @SubscribeEvent
    public static void onMovementKeyPressed(MovementInputUpdateEvent event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null && BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler((LivingEntity)player)) > 0) {
            event.getInput().leftImpulse = 0.0f;
        }
    }

    @SubscribeEvent
    public static void changeFov(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        if (player.getUseItem().getItem() instanceof BucklerItem) {
            int i = player.getTicksUsingItem();
            float f1 = (float)i * 0.3f;
            if (f1 < 1.0f) {
                f1 = 1.0f;
            }
            f1 = Math.max(f1, event.getFovModifier());
            event.setNewFovModifier(f1);
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        PoseStack mStack = event.getPoseStack();
        ItemStack stack = event.getItemStack();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        float partialTicks = event.getPartialTick();
        if (stack.getItem() instanceof BucklerItem && player != null && (player.isUsingItem() && player.getUseItem() == stack || BucklerItem.getChargeTicks(stack) > 0 && BucklerItem.isReady(stack))) {
            boolean mainHand = event.getHand() == InteractionHand.MAIN_HAND;
            HumanoidArm handside = mainHand ? player.getMainArm() : player.getMainArm().getOpposite();
            boolean rightHanded = handside == HumanoidArm.RIGHT;
            float f7 = (float)stack.getUseDuration((LivingEntity)player) - ((float)player.getUseItemRemainingTicks() - partialTicks + 1.0f);
            float f11 = f7 / 10.0f;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            mStack.pushPose();
            int i = rightHanded ? 1 : -1;
            mStack.translate((float)i * 0.56f, -0.52f + event.getEquipProgress() * -0.6f, -0.72f);
            mStack.translate((double)f11 * (!rightHanded ? 0.2 : -0.2), 0.0, (double)f11 * (!rightHanded ? 0.2 : -0.2));
            ItemDisplayContext transform = rightHanded ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
            Minecraft.getInstance().gameRenderer.itemInHandRenderer.renderItem((LivingEntity)player, stack, transform, !rightHanded, mStack, event.getMultiBufferSource(), event.getPackedLight());
            mStack.popPose();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void modifyItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Minecraft minecraft = Minecraft.getInstance();
        if (stack.getItem() == PPItems.BUCKLER.get() && event.getEntity() != null && event.getEntity().isLocalPlayer()) {
            ArrayList<Object> toAdd = new ArrayList<Object>();
            toAdd.add(Component.empty());
            toAdd.addAll(((BucklerItem)((Object)PPItems.BUCKLER.get())).getDescription(stack));
            if (((Boolean)PPConfig.CLIENT.bucklerDesc.get()).booleanValue()) {
                event.getToolTip().addAll(toAdd);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTurnCalculation(CalculatePlayerTurnEvent event) {
        double turningValue;
        double mouseSensitivity = event.getMouseSensitivity();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (turningValue = PPAttributes.turningValue((LivingEntity)player)) != 1.0) {
            mouseSensitivity = mouseSensitivity * turningValue - (double)0.2f;
        }
        event.setMouseSensitivity(mouseSensitivity);
    }
}

