/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation;

import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.registries.DeferredHolder;
import tallestred.piglinproliferation.client.renderers.BucklerRenderer;
import tallestred.piglinproliferation.common.blocks.FireRingBlockColor;
import tallestred.piglinproliferation.common.blocks.PPBlocks;
import tallestred.piglinproliferation.common.items.BucklerItem;
import tallestred.piglinproliferation.common.items.PPItems;
import tallestred.piglinproliferation.common.items.component.PPComponents;
import tallestred.piglinproliferation.common.items.component.TravelersCompassTracker;

@Mod(value="piglinproliferation", dist={Dist.CLIENT})
public class PiglinProliferationClient {
    public PiglinProliferationClient(IEventBus modEventBus, Dist dist, ModContainer container) {
        modEventBus.addListener(this::doClientStuff);
        modEventBus.addListener(this::doClientExtensionsStuff);
        modEventBus.addListener(this::doBlockColorStuff);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    private void doClientExtensionsStuff(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(this){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new BucklerRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
            }
        }, new Item[]{(Item)PPItems.BUCKLER.get()});
    }

    private void doBlockColorStuff(RegisterColorHandlersEvent.Block event) {
        event.register((BlockColor)new FireRingBlockColor(), (Block[])PPBlocks.FIRE_RINGS.stream().map(DeferredHolder::get).toArray(Block[]::new));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)PPItems.BUCKLER.get()), (ResourceLocation)ResourceLocation.parse((String)"blocking"), (stack, clientWorld, livingEntity, useTime) -> {
                boolean active = livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == stack || livingEntity != null && BucklerItem.isReady(stack);
                return livingEntity != null && active ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)((Item)PPItems.TRAVELERS_COMPASS.get()), (ResourceLocation)ResourceLocation.parse((String)"angle"), (ItemPropertyFunction)new CompassItemPropertyFunction((level, itemStack, player) -> {
                TravelersCompassTracker tracker = (TravelersCompassTracker)itemStack.get(PPComponents.TRAVELERS_COMPASS_TRACKER);
                if (tracker != null) {
                    return tracker.target();
                }
                return null;
            }));
        });
    }
}

