/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.util;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforgespi.language.IModInfo;

public class Platform {
    private static List<IModInfo> cachedForgeModList;

    public static void executeDist(Environment env, Supplier<Runnable> runnableSupplier) {
        if (Platform.getEnvironment() == env) {
            runnableSupplier.get().run();
        }
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static List<Mod> getModList() {
        return Platform.getForgeMods().stream().map(mod -> new Mod((IModInfo)mod){
            final /* synthetic */ IModInfo val$mod;
            {
                this.val$mod = iModInfo;
            }

            @Override
            public String getId() {
                return this.val$mod.getModId();
            }

            @Override
            public String getVersion() {
                return this.val$mod.getVersion().toString();
            }
        }).sorted(Comparator.comparing(Mod::getId)).collect(Collectors.toList());
    }

    public static Environment getEnvironment() {
        switch (FMLLoader.getDist()) {
            case CLIENT: {
                return Environment.CLIENT;
            }
            case DEDICATED_SERVER: {
                return Environment.SERVER;
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean mpucAuthor() {
        return Platform.getGameDir().resolve(".mpuc-author").toFile().exists();
    }

    private static List<IModInfo> getForgeMods() {
        if (cachedForgeModList == null) {
            cachedForgeModList = new ArrayList<IModInfo>(LoadingModList.get().getMods());
        }
        return cachedForgeModList;
    }

    public static enum Environment {
        CLIENT,
        SERVER;

    }

    public static interface Mod {
        public String getId();

        public String getVersion();
    }
}

