/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.util;

import com.jab125.mpuc.util.ClickEventUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ChangelogUtils {
    private static final Pattern URL_PATTERN = Pattern.compile("\\[(?<displayname>.+?)]\\((?<embeddedurl>(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])\\)|(?<autourl>(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])");

    public static Component fromString(String text) {
        text = text.replaceAll("\r\n", "\n");
        MutableComponent d = Component.empty();
        try {
            Matcher matcher = URL_PATTERN.matcher(text);
            int end = 0;
            while (matcher.find()) {
                d.append((Component)Component.literal((String)text.substring(end, matcher.start())));
                end = matcher.end();
                String autoUrl = matcher.group("autourl");
                if (autoUrl != null) {
                    d.append((Component)Component.literal((String)autoUrl).withStyle(style -> style.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE).withClickEvent(ClickEventUtils.url(autoUrl))));
                    continue;
                }
                d.append((Component)Component.literal((String)matcher.group("displayname")).withStyle(style -> style.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE).withClickEvent(ClickEventUtils.url(matcher.group("embeddedurl")))));
            }
            d.append((Component)Component.literal((String)text.substring(end)));
            return d;
        }
        catch (Throwable t) {
            return d.append((Component)Component.literal((String)text));
        }
    }
}

