/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.server.util.text;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.jab125.mpuc.server.util.text.ServerTextCollector;
import com.jab125.mpuc.server.util.text.ServerTextVisitFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class ServerTextHandler {
    final WidthRetriever widthRetriever;

    public ServerTextHandler(WidthRetriever widthRetriever) {
        this.widthRetriever = widthRetriever;
    }

    public float getWidth(@Nullable String text) {
        if (text == null) {
            return 0.0f;
        }
        MutableFloat mutableFloat = new MutableFloat();
        ServerTextVisitFactory.visitFormatted(text, Style.EMPTY, (unused, style, codePoint) -> {
            mutableFloat.add(this.widthRetriever.getWidth(codePoint, style));
            return true;
        });
        return mutableFloat.floatValue();
    }

    public float getWidth(FormattedText text) {
        MutableFloat mutableFloat = new MutableFloat();
        ServerTextVisitFactory.visitFormatted(text, Style.EMPTY, (unused, style, codePoint) -> {
            mutableFloat.add(this.widthRetriever.getWidth(codePoint, style));
            return true;
        });
        return mutableFloat.floatValue();
    }

    public float getWidth(FormattedCharSequence text) {
        MutableFloat mutableFloat = new MutableFloat();
        text.accept((index, style, codePoint) -> {
            mutableFloat.add(this.widthRetriever.getWidth(codePoint, style));
            return true;
        });
        return mutableFloat.floatValue();
    }

    public int getTrimmedLength(String text, int maxWidth, Style style) {
        WidthLimitingVisitor widthLimitingVisitor = new WidthLimitingVisitor(maxWidth);
        ServerTextVisitFactory.visitForwards(text, style, widthLimitingVisitor);
        return widthLimitingVisitor.getLength();
    }

    public String trimToWidth(String text, int maxWidth, Style style) {
        return text.substring(0, this.getTrimmedLength(text, maxWidth, style));
    }

    public String trimToWidthBackwards(String text, int maxWidth, Style style2) {
        MutableFloat mutableFloat = new MutableFloat();
        MutableInt mutableInt = new MutableInt(text.length());
        ServerTextVisitFactory.visitBackwards(text, style2, (index, style, codePoint) -> {
            float f = mutableFloat.addAndGet(this.widthRetriever.getWidth(codePoint, style));
            if (f > (float)maxWidth) {
                return false;
            }
            mutableInt.setValue(index);
            return true;
        });
        return text.substring(mutableInt.intValue());
    }

    public int getLimitedStringLength(String text, int maxWidth, Style style) {
        WidthLimitingVisitor widthLimitingVisitor = new WidthLimitingVisitor(maxWidth);
        ServerTextVisitFactory.visitFormatted(text, style, (FormattedCharSink)widthLimitingVisitor);
        return widthLimitingVisitor.getLength();
    }

    @Nullable
    public Style getStyleAt(FormattedText text2, int x) {
        WidthLimitingVisitor widthLimitingVisitor = new WidthLimitingVisitor(x);
        return text2.visit((style, text) -> ServerTextVisitFactory.visitFormatted(text, style, (FormattedCharSink)widthLimitingVisitor) ? Optional.empty() : Optional.of(style), Style.EMPTY).orElse(null);
    }

    @Nullable
    public Style getStyleAt(FormattedCharSequence text, int x) {
        WidthLimitingVisitor widthLimitingVisitor = new WidthLimitingVisitor(x);
        MutableObject mutableObject = new MutableObject();
        text.accept((index, style, codePoint) -> {
            if (!widthLimitingVisitor.accept(index, style, codePoint)) {
                mutableObject.setValue((Object)style);
                return false;
            }
            return true;
        });
        return (Style)mutableObject.getValue();
    }

    public String limitString(String text, int maxWidth, Style style) {
        return text.substring(0, this.getLimitedStringLength(text, maxWidth, style));
    }

    public FormattedText trimToWidth(FormattedText text, int width, Style style) {
        final WidthLimitingVisitor widthLimitingVisitor = new WidthLimitingVisitor(width);
        return text.visit((FormattedText.StyledContentConsumer)new FormattedText.StyledContentConsumer<FormattedText>(){
            private final ServerTextCollector collector = new ServerTextCollector();

            public Optional<FormattedText> accept(Style style, String string) {
                widthLimitingVisitor.resetLength();
                if (!ServerTextVisitFactory.visitFormatted(string, style, (FormattedCharSink)widthLimitingVisitor)) {
                    String string2 = string.substring(0, widthLimitingVisitor.getLength());
                    if (!string2.isEmpty()) {
                        this.collector.add(FormattedText.of((String)string2, (Style)style));
                    }
                    return Optional.of(this.collector.getCombined());
                }
                if (!string.isEmpty()) {
                    this.collector.add(FormattedText.of((String)string, (Style)style));
                }
                return Optional.empty();
            }
        }, style).orElse(text);
    }

    public List<MatchResult> getStyleMatchResults(FormattedCharSequence text, Predicate<Style> stylePredicate) {
        StylePredicateVisitor stylePredicateVisitor = new StylePredicateVisitor(stylePredicate);
        text.accept((FormattedCharSink)stylePredicateVisitor);
        return stylePredicateVisitor.getResults();
    }

    public int getEndingIndex(String text, int maxWidth, Style style) {
        LineBreakingVisitor lineBreakingVisitor = new LineBreakingVisitor(maxWidth);
        ServerTextVisitFactory.visitFormatted(text, style, (FormattedCharSink)lineBreakingVisitor);
        return lineBreakingVisitor.getEndingIndex();
    }

    public static int moveCursorByWords(String text, int offset, int cursor, boolean consumeSpaceOrBreak) {
        int i = cursor;
        boolean bl = offset < 0;
        int j = Math.abs(offset);
        for (int k = 0; k < j; ++k) {
            if (bl) {
                while (consumeSpaceOrBreak && i > 0 && (text.charAt(i - 1) == ' ' || text.charAt(i - 1) == '\n')) {
                    --i;
                }
                while (i > 0 && text.charAt(i - 1) != ' ' && text.charAt(i - 1) != '\n') {
                    --i;
                }
                continue;
            }
            int l = text.length();
            int m = text.indexOf(32, i);
            int n = text.indexOf(10, i);
            int n2 = m == -1 && n == -1 ? -1 : (m != -1 && n != -1 ? Math.min(m, n) : (i = m != -1 ? m : n));
            if (i == -1) {
                i = l;
                continue;
            }
            while (consumeSpaceOrBreak && i < l && (text.charAt(i) == ' ' || text.charAt(i) == '\n')) {
                ++i;
            }
        }
        return i;
    }

    public void wrapLines(String text, int maxWidth, Style style, boolean retainTrailingWordSplit, LineWrappingConsumer consumer) {
        int i = 0;
        int j = text.length();
        Style style2 = style;
        while (i < j) {
            LineBreakingVisitor lineBreakingVisitor = new LineBreakingVisitor(maxWidth);
            boolean bl = ServerTextVisitFactory.visitFormatted(text, i, style2, style, lineBreakingVisitor);
            if (bl) {
                consumer.accept(style2, i, j);
                break;
            }
            int k = lineBreakingVisitor.getEndingIndex();
            char c = text.charAt(k);
            int l = c == '\n' || c == ' ' ? k + 1 : k;
            consumer.accept(style2, i, retainTrailingWordSplit ? l : k);
            i = l;
            style2 = lineBreakingVisitor.getEndingStyle();
        }
    }

    public List<FormattedText> wrapLines(String text, int maxWidth, Style style2) {
        ArrayList list = Lists.newArrayList();
        this.wrapLines(text, maxWidth, style2, false, (style, start, end) -> list.add(FormattedText.of((String)text.substring(start, end), (Style)style)));
        return list;
    }

    public List<FormattedText> wrapLines(FormattedText text2, int maxWidth, Style style) {
        ArrayList list = Lists.newArrayList();
        this.wrapLines(text2, maxWidth, style, (FormattedText text, Boolean lastLineWrapped) -> list.add(text));
        return list;
    }

    public List<FormattedText> wrapLines(FormattedText text2, int maxWidth, Style style, FormattedText wrappedLinePrefix) {
        ArrayList list = Lists.newArrayList();
        this.wrapLines(text2, maxWidth, style, (FormattedText text, Boolean lastLineWrapped) -> list.add(lastLineWrapped != false ? FormattedText.composite((FormattedText[])new FormattedText[]{wrappedLinePrefix, text}) : text));
        return list;
    }

    public void wrapLines(FormattedText text2, int maxWidth, Style style2, BiConsumer<FormattedText, Boolean> lineConsumer) {
        ArrayList list = Lists.newArrayList();
        text2.visit((style, text) -> {
            if (!text.isEmpty()) {
                list.add(new StyledString(text, style));
            }
            return Optional.empty();
        }, style2);
        LineWrappingCollector lineWrappingCollector = new LineWrappingCollector(list);
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        block0: while (bl) {
            bl = false;
            LineBreakingVisitor lineBreakingVisitor = new LineBreakingVisitor(maxWidth);
            for (StyledString styledString : lineWrappingCollector.parts) {
                boolean bl4 = ServerTextVisitFactory.visitFormatted(styledString.literal, 0, styledString.style, style2, lineBreakingVisitor);
                if (!bl4) {
                    int i = lineBreakingVisitor.getEndingIndex();
                    Style style22 = lineBreakingVisitor.getEndingStyle();
                    char c = lineWrappingCollector.charAt(i);
                    boolean bl5 = c == '\n';
                    boolean bl6 = bl5 || c == ' ';
                    bl2 = bl5;
                    FormattedText stringVisitable = lineWrappingCollector.collectLine(i, bl6 ? 1 : 0, style22);
                    lineConsumer.accept(stringVisitable, bl3);
                    bl3 = !bl5;
                    bl = true;
                    continue block0;
                }
                lineBreakingVisitor.offset(styledString.literal.length());
            }
        }
        FormattedText stringVisitable2 = lineWrappingCollector.collectRemainers();
        if (stringVisitable2 != null) {
            lineConsumer.accept(stringVisitable2, bl3);
        } else if (bl2) {
            lineConsumer.accept(FormattedText.EMPTY, false);
        }
    }

    @FunctionalInterface
    public static interface WidthRetriever {
        public float getWidth(int var1, Style var2);
    }

    class WidthLimitingVisitor
    implements FormattedCharSink {
        private float widthLeft;
        private int length;

        public WidthLimitingVisitor(float maxWidth) {
            this.widthLeft = maxWidth;
        }

        public boolean accept(int i, Style style, int j) {
            this.widthLeft -= ServerTextHandler.this.widthRetriever.getWidth(j, style);
            if (this.widthLeft >= 0.0f) {
                this.length = i + Character.charCount(j);
                return true;
            }
            return false;
        }

        public int getLength() {
            return this.length;
        }

        public void resetLength() {
            this.length = 0;
        }
    }

    class StylePredicateVisitor
    implements FormattedCharSink {
        private final Predicate<Style> stylePredicate;
        private float totalWidth;
        private final ImmutableList.Builder<MatchResult> results = ImmutableList.builder();
        private float styleStartWidth;
        private boolean lastTestResult;

        StylePredicateVisitor(Predicate<Style> stylePredicate) {
            this.stylePredicate = stylePredicate;
        }

        public boolean accept(int i, Style style, int j) {
            boolean bl = this.stylePredicate.test(style);
            if (this.lastTestResult != bl) {
                if (bl) {
                    this.onStyleMatchStart();
                } else {
                    this.onStyleMatchEnd();
                }
            }
            this.totalWidth += ServerTextHandler.this.widthRetriever.getWidth(j, style);
            return true;
        }

        private void onStyleMatchStart() {
            this.lastTestResult = true;
            this.styleStartWidth = this.totalWidth;
        }

        private void onStyleMatchEnd() {
            float f = this.totalWidth;
            this.results.add((Object)new MatchResult(this.styleStartWidth, f));
            this.lastTestResult = false;
        }

        public List<MatchResult> getResults() {
            if (this.lastTestResult) {
                this.onStyleMatchEnd();
            }
            return this.results.build();
        }
    }

    class LineBreakingVisitor
    implements FormattedCharSink {
        private final float maxWidth;
        private int endIndex = -1;
        private Style endStyle = Style.EMPTY;
        private boolean nonEmpty;
        private float totalWidth;
        private int lastSpaceBreak = -1;
        private Style lastSpaceStyle = Style.EMPTY;
        private int count;
        private int startOffset;

        public LineBreakingVisitor(float maxWidth) {
            this.maxWidth = Math.max(maxWidth, 1.0f);
        }

        public boolean accept(int i, Style style, int j) {
            int k = i + this.startOffset;
            switch (j) {
                case 10: {
                    return this.breakLine(k, style);
                }
                case 32: {
                    this.lastSpaceBreak = k;
                    this.lastSpaceStyle = style;
                }
            }
            float f = ServerTextHandler.this.widthRetriever.getWidth(j, style);
            this.totalWidth += f;
            if (this.nonEmpty && this.totalWidth > this.maxWidth) {
                if (this.lastSpaceBreak != -1) {
                    return this.breakLine(this.lastSpaceBreak, this.lastSpaceStyle);
                }
                return this.breakLine(k, style);
            }
            this.nonEmpty |= f != 0.0f;
            this.count = k + Character.charCount(j);
            return true;
        }

        private boolean breakLine(int finishIndex, Style finishStyle) {
            this.endIndex = finishIndex;
            this.endStyle = finishStyle;
            return false;
        }

        private boolean hasLineBreak() {
            return this.endIndex != -1;
        }

        public int getEndingIndex() {
            return this.hasLineBreak() ? this.endIndex : this.count;
        }

        public Style getEndingStyle() {
            return this.endStyle;
        }

        public void offset(int extraOffset) {
            this.startOffset += extraOffset;
        }
    }

    @FunctionalInterface
    public static interface LineWrappingConsumer {
        public void accept(Style var1, int var2, int var3);
    }

    static class LineWrappingCollector {
        final List<StyledString> parts;
        private String joined;

        public LineWrappingCollector(List<StyledString> parts) {
            this.parts = parts;
            this.joined = parts.stream().map(part -> part.literal).collect(Collectors.joining());
        }

        public char charAt(int index) {
            return this.joined.charAt(index);
        }

        public FormattedText collectLine(int lineLength, int skippedLength, Style style) {
            ServerTextCollector ServerTextCollector2 = new ServerTextCollector();
            ListIterator<StyledString> listIterator = this.parts.listIterator();
            int i = lineLength;
            boolean bl = false;
            while (listIterator.hasNext()) {
                String string2;
                StyledString styledString = listIterator.next();
                String string = styledString.literal;
                int j = string.length();
                if (!bl) {
                    if (i > j) {
                        ServerTextCollector2.add(styledString);
                        listIterator.remove();
                        i -= j;
                    } else {
                        string2 = string.substring(0, i);
                        if (!string2.isEmpty()) {
                            ServerTextCollector2.add(FormattedText.of((String)string2, (Style)styledString.style));
                        }
                        i += skippedLength;
                        bl = true;
                    }
                }
                if (!bl) continue;
                if (i > j) {
                    listIterator.remove();
                    i -= j;
                    continue;
                }
                string2 = string.substring(i);
                if (string2.isEmpty()) {
                    listIterator.remove();
                    break;
                }
                listIterator.set(new StyledString(string2, style));
                break;
            }
            this.joined = this.joined.substring(lineLength + skippedLength);
            return ServerTextCollector2.getCombined();
        }

        @Nullable
        public FormattedText collectRemainers() {
            ServerTextCollector ServerTextCollector2 = new ServerTextCollector();
            this.parts.forEach(ServerTextCollector2::add);
            this.parts.clear();
            return ServerTextCollector2.getRawCombined();
        }
    }

    static class StyledString
    implements FormattedText {
        final String literal;
        final Style style;

        public StyledString(String literal, Style style) {
            this.literal = literal;
            this.style = style;
        }

        public <T> Optional<T> visit(FormattedText.ContentConsumer<T> visitor) {
            return visitor.accept(this.literal);
        }

        public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> styledVisitor, Style style) {
            return styledVisitor.accept(this.style.applyTo(style), this.literal);
        }
    }

    public static final class MatchResult {
        private final float left;
        private final float right;

        public MatchResult(float left, float right) {
            this.left = left;
            this.right = right;
        }

        public float left() {
            return this.left;
        }

        public float right() {
            return this.right;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            MatchResult that = (MatchResult)obj;
            return Float.floatToIntBits(this.left) == Float.floatToIntBits(that.left) && Float.floatToIntBits(this.right) == Float.floatToIntBits(that.right);
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.left), Float.valueOf(this.right));
        }

        public String toString() {
            return "MatchResult[left=" + this.left + ", right=" + this.right + "]";
        }
    }
}

