/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.server.util.text;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public class ServerTextCollector {
    private final List<FormattedText> texts = Lists.newArrayList();

    public void add(FormattedText text) {
        this.texts.add(text);
    }

    @Nullable
    public FormattedText getRawCombined() {
        if (this.texts.isEmpty()) {
            return null;
        }
        if (this.texts.size() == 1) {
            return this.texts.get(0);
        }
        return FormattedText.composite(this.texts);
    }

    public FormattedText getCombined() {
        FormattedText stringVisitable = this.getRawCombined();
        return stringVisitable != null ? stringVisitable : FormattedText.EMPTY;
    }

    public void clear() {
        this.texts.clear();
    }
}

