/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.recipe;

import com.google.common.collect.Lists;
import com.jab125.mpuc.Mpuc;
import com.jab125.mpuc.api.MpucApi;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.server.util.BookWriter;
import com.jab125.mpuc.util.ChangelogUtils;
import com.jab125.mpuc.util.OnlineInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ChangelogBookRecipe
extends CustomRecipe {
    private final Ingredient r = Ingredient.of((ItemLike[])new ItemLike[0]);
    private final NonNullList<Ingredient> input = NonNullList.of(null, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.LAPIS_LAZULI}), Ingredient.of((ItemLike[])new ItemLike[]{Items.COMPASS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAPIS_LAZULI}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER}), this.r, Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})});

    public ChangelogBookRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inventory, Level world) {
        for (int i = 0; i <= inventory.width() - 3; ++i) {
            for (int j = 0; j <= inventory.height() - 3; ++j) {
                if (this.matchesPattern(inventory, i, j, true)) {
                    return true;
                }
                if (!this.matchesPattern(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack craft(CraftingInput inventory, HolderLookup.Provider lookup) {
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!stack.is(Items.BOOK)) continue;
            String name = stack.getHoverName().getString();
            Map<String, OnlineInfo.Version> versions = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions;
            Optional<Map.Entry> version = versions.entrySet().stream().filter(a -> name.equals(((OnlineInfo.Version)a.getValue()).id)).findFirst();
            if (version.isPresent()) {
                ItemStack itemStack = new ItemStack((ItemLike)Items.WRITTEN_BOOK);
                BookWriter.writeBook(itemStack, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Component[]{Component.nullToEmpty((String)(MpucApi.getInstance().getModpackName() + " " + ((OnlineInfo.Version)version.get().getValue()).id))}), Lists.newArrayList((Object[])new Component[]{ChangelogUtils.fromString(((OnlineInfo.Version)version.get().getValue()).changelog())})}), MpucApi.getInstance().getModpackName() + " " + ((OnlineInfo.Version)version.get().getValue()).id, lookup);
                return itemStack;
            }
            return Items.FEATHER.getDefaultInstance();
        }
        return Items.FEATHER.getDefaultInstance();
    }

    private boolean matchesPattern(CraftingInput inv, int offsetX, int offsetY, boolean flipped) {
        for (int i = 0; i < inv.width(); ++i) {
            for (int j = 0; j < inv.height(); ++j) {
                int k = i - offsetX;
                int l = j - offsetY;
                Ingredient ingredient = Ingredient.EMPTY;
                if (k >= 0 && l >= 0 && k < 3 && l < 3) {
                    Ingredient ingredient2 = ingredient = flipped ? (Ingredient)this.input.get(3 - k - 1 + l * 3) : (Ingredient)this.input.get(k + l * 3);
                }
                if (ingredient == this.r) {
                    ItemStack stack = inv.getItem(i + j * inv.width());
                    if (stack.is(Items.BOOK) && stack.get(DataComponents.CUSTOM_NAME) != null) {
                        String name = stack.getHoverName().getString();
                        Map<String, OnlineInfo.Version> versions = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions;
                        if (versions.entrySet().stream().anyMatch(a -> name.equals(((OnlineInfo.Version)a.getValue()).id))) {
                            continue;
                        }
                    }
                } else if (ingredient.test(inv.getItem(i + j * inv.width()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)BuiltInRegistries.RECIPE_SERIALIZER.get(ResourceLocation.fromNamespaceAndPath((String)"modpack-update-checker", (String)"changelog_book"));
    }

    public static void register() {
        String id = "changelog_book";
        DeferredRegister deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"modpack-update-checker");
        deferredRegister.register(Mpuc.modEventBus);
        deferredRegister.register(id, () -> new SimpleCraftingRecipeSerializer(ChangelogBookRecipe::new));
    }
}

