/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.mixin;

import com.jab125.mpuc.api.ModpackInfo;
import com.jab125.mpuc.api.MpucApi;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.extension.LevelSummaryExtension;
import com.jab125.mpuc.util.OnlineInfo;
import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldSelectionList.WorldListEntry.class})
public abstract class WorldListWidgetWorldEntryMixin {
    @Shadow
    @Final
    private LevelSummary summary;
    @Shadow
    @Final
    private SelectWorldScreen screen;
    @Shadow
    @Final
    private Minecraft minecraft;
    private final ThreadLocal<Boolean> CALLED = ThreadLocal.withInitial(() -> false);

    @Shadow
    public abstract void joinWorld();

    @Inject(method={"joinWorld()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void mpuc$play(CallbackInfo ci) {
        OnlineInfo.Version version;
        if (this.CALLED.get().booleanValue()) {
            return;
        }
        boolean unavailable = this.summary.isDisabled() || ((LevelSummaryExtension)this.summary).mpuc$modpackUnavailable();
        ModpackInfo modpackInfo = MpucApi.getInstance().getModpackInfo(this.summary.getSettings());
        MpucApi api = MpucApi.getInstance();
        if (modpackInfo.getModpackName() == null && !ConfigInstances.getModpackUpdateCheckerConfig().retroWarning) {
            return;
        }
        if (Objects.equals(api.getModpackName(), modpackInfo.getModpackName()) && api.getCurrentModpackVersion().equals(modpackInfo.getModpackVersion())) {
            return;
        }
        if (Objects.equals(api.getModpackName(), modpackInfo.getModpackName()) && (version = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions.get(modpackInfo.getModpackVersion())) != null && this.calulate0(version) == OnlineInfo.UpdateType.MINOR) {
            return;
        }
        String string2 = unavailable ? "pack.incompatible" : "selectWorld.backupQuestion.snapshot";
        MutableComponent mutableText = Component.translatable((String)string2);
        MutableComponent text = Component.translatable((String)("screen.modpack-update-checker.select-world." + (unavailable ? "modpack-backup.incompatible" : "modpack-backup")), (Object[])new Object[]{modpackInfo.getModpackName() == null ? "Minecraft" : modpackInfo.getModpackName(), modpackInfo.getModpackName() == null ? this.summary.levelVersion().minecraftVersionName() : modpackInfo.getModpackVersion(), api.getModpackName(), api.getCurrentModpackVersion()});
        if (unavailable && !ConfigInstances.getModpackUpdateCheckerConfig().forceModpackCompatible) {
            this.minecraft.setScreen((Screen)new AlertScreen(() -> this.minecraft.setScreen((Screen)this.screen), (Component)mutableText, (Component)text));
        } else {
            this.minecraft.setScreen((Screen)new BackupConfirmScreen(() -> this.minecraft.setScreen((Screen)this.screen), (backup, eraseCache) -> {
                if (backup) {
                    String string = this.summary.getLevelId();
                    try (LevelStorageSource.LevelStorageAccess session = this.minecraft.getLevelSource().createAccess(string);){
                        EditWorldScreen.makeBackupAndShowToast((LevelStorageSource.LevelStorageAccess)session);
                    }
                    catch (IOException exception) {
                        SystemToast.onWorldAccessFailure((Minecraft)this.minecraft, (String)string);
                    }
                }
                this.CALLED.set(true);
                this.joinWorld();
                this.CALLED.set(false);
            }, (Component)mutableText, (Component)text, false));
        }
        ci.cancel();
    }

    @Unique
    private OnlineInfo.UpdateType calulate0(OnlineInfo.Version currentVersion) {
        OnlineInfo.Version currentModpackVersion = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions.get(ConfigInstances.getModpackUpdateCheckerConfig().currentVersion);
        if (currentModpackVersion == null) {
            return OnlineInfo.UpdateType.INCOMPATIBLE;
        }
        OnlineInfo associatedOnlineInfo = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo();
        if (currentVersion.internalId > currentModpackVersion.internalId) {
            return OnlineInfo.UpdateType.INCOMPATIBLE;
        }
        Optional<OnlineInfo.UpdateType> updateType = associatedOnlineInfo.versions.values().stream().filter(version -> version.internalId < currentModpackVersion.internalId && version.internalId >= currentVersion.internalId).map(version -> version.updateType == null ? OnlineInfo.UpdateType.MINOR : version.updateType).max(Comparator.naturalOrder());
        if (updateType.isEmpty()) {
            return null;
        }
        return updateType.get();
    }
}

