/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.mixin;

import com.jab125.mpuc.api.MpucApi;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.extension.LevelSummaryExtension;
import com.jab125.mpuc.util.OnlineInfo;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.LevelSummary;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelSummary.class})
public abstract class LevelSummaryMixin
implements LevelSummaryExtension {
    @Shadow
    @Final
    private LevelSettings settings;
    @Unique
    private static final int ORDINAL = 7;
    @Unique
    private static final String METHOD_NAME = "createDetails";
    @Unique
    private static final String LOCKED = "isUnavailable";
    @Unique
    private final ThreadLocal<Boolean> invokeWithout = ThreadLocal.withInitial(() -> true);

    @Shadow
    public abstract boolean isDisabled();

    @Unique
    private boolean mpuc$d() {
        return this.isDisabled();
    }

    @Inject(method={"createInfo()Lnet/minecraft/network/chat/Component;"}, at={@At(value="HEAD")}, cancellable=true)
    private void mpuc$createDetails0(CallbackInfoReturnable<Component> cir) {
        boolean actuallyLocked = this.mpuc$d();
        if (actuallyLocked) {
            return;
        }
        this.invokeWithout.set(false);
        boolean mixinLocked = this.mpuc$d();
        this.invokeWithout.set(true);
        if (mixinLocked) {
            cir.setReturnValue((Object)Component.translatable((String)"screen.modpack-update-checker.select-world.incompatible-modpack-version").withStyle(ChatFormatting.RED));
        }
    }

    @ModifyArg(method={"createInfo()Lnet/minecraft/network/chat/Component;"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/chat/MutableComponent;append(Lnet/minecraft/network/chat/Component;)Lnet/minecraft/network/chat/MutableComponent;", ordinal=7))
    private Component mpuc$createDetails(Component text) {
        String modpackName = MpucApi.getInstance().getModpackInfo(this.settings).getModpackName();
        String modpackVersion = MpucApi.getInstance().getModpackInfo(this.settings).getModpackVersion();
        if (modpackName == null || modpackVersion == null) {
            return text;
        }
        MutableComponent one = Component.literal((String)modpackName);
        MutableComponent comma = Component.literal((String)": ");
        MutableComponent two = Component.literal((String)modpackVersion);
        if (!modpackName.equals(MpucApi.getInstance().getModpackName())) {
            one = one.withStyle(ChatFormatting.RED);
            comma = comma.withStyle(ChatFormatting.RED);
            two = two.withStyle(ChatFormatting.RED);
        }
        if (!modpackVersion.equals(MpucApi.getInstance().getModpackVersion())) {
            Map<String, OnlineInfo.Version> versions = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions;
            OnlineInfo.Version currentVersion = versions.get(modpackVersion);
            Style formatting = currentVersion == null ? (!modpackVersion.equals(MpucApi.getInstance().getModpackVersion()) ? Style.EMPTY.withColor(ChatFormatting.RED) : Style.EMPTY) : this.calulate(currentVersion);
            two = two.withStyle(formatting);
        }
        return Component.literal((String)", ").append((Component)one).append((Component)comma).append((Component)two);
    }

    @Unique
    private Style calulate(OnlineInfo.Version currentVersion) {
        OnlineInfo.Version currentModpackVersion = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions.get(ConfigInstances.getModpackUpdateCheckerConfig().currentVersion);
        if (currentModpackVersion == null) {
            return Style.EMPTY.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true));
        }
        OnlineInfo associatedOnlineInfo = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo();
        if (currentVersion.internalId > currentModpackVersion.internalId) {
            return Style.EMPTY.withColor(ChatFormatting.RED);
        }
        Optional<OnlineInfo.UpdateType> updateType = associatedOnlineInfo.versions.values().stream().filter(version -> version.internalId < currentModpackVersion.internalId && version.internalId >= currentVersion.internalId).map(version -> version.updateType == null ? OnlineInfo.UpdateType.MINOR : version.updateType).max(Comparator.naturalOrder());
        if (updateType.isEmpty()) {
            return null;
        }
        OnlineInfo.UpdateType updateType1 = updateType.get();
        switch (updateType1) {
            case INCOMPATIBLE: {
                return Style.EMPTY.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true));
            }
            case MAJOR: {
                return Style.EMPTY.withColor(ChatFormatting.RED);
            }
            case MINOR_BREAKING: {
                return Style.EMPTY.withItalic(Boolean.valueOf(true)).withBold(Boolean.valueOf(true));
            }
            case MINOR: {
                return Style.EMPTY.withItalic(Boolean.valueOf(true));
            }
        }
        throw new IllegalArgumentException();
    }

    @Unique
    private OnlineInfo.UpdateType calulate0(OnlineInfo.Version currentVersion) {
        OnlineInfo.Version currentModpackVersion = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions.get(ConfigInstances.getModpackUpdateCheckerConfig().currentVersion);
        if (currentModpackVersion == null) {
            return OnlineInfo.UpdateType.INCOMPATIBLE;
        }
        OnlineInfo associatedOnlineInfo = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo();
        if (currentVersion.internalId > currentModpackVersion.internalId) {
            return OnlineInfo.UpdateType.INCOMPATIBLE;
        }
        Optional<OnlineInfo.UpdateType> updateType = associatedOnlineInfo.versions.values().stream().filter(version -> version.internalId < currentModpackVersion.internalId && version.internalId >= currentVersion.internalId).map(version -> version.updateType == null ? OnlineInfo.UpdateType.MINOR : version.updateType).max(Comparator.naturalOrder());
        if (updateType.isEmpty()) {
            return null;
        }
        return updateType.get();
    }

    @Inject(method={"isDisabled()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void mpuc$isUnavailable(CallbackInfoReturnable<Boolean> cir) {
        if (this.invokeWithout.get().booleanValue()) {
            return;
        }
        if (this.modpackUnavailable()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private boolean modpackUnavailable() {
        String modpackName = MpucApi.getInstance().getModpackInfo(this.settings).getModpackName();
        String modpackVersion = MpucApi.getInstance().getModpackInfo(this.settings).getModpackVersion();
        if (modpackName == null && ConfigInstances.getModpackUpdateCheckerConfig().retroAllow) {
            return false;
        }
        if (!Objects.equals(MpucApi.getInstance().getModpackName(), modpackName)) {
            return true;
        }
        Map<String, OnlineInfo.Version> versions = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions;
        OnlineInfo.Version currentVersion = versions.get(modpackVersion);
        if (currentVersion == null) {
            return false;
        }
        return this.calulate0(currentVersion) == OnlineInfo.UpdateType.INCOMPATIBLE;
    }

    @Override
    public boolean mpuc$modpackUnavailable() {
        return this.modpackUnavailable();
    }
}

