/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget.flow.widgets;

import com.jab125.mpuc.client.gui.widget.flow.widgets.AbstractWidget;
import com.jab125.mpuc.client.util.Context;
import com.jab125.mpuc.extension.ClickableWidgetExtension;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;

public class WrappedElementWidget
extends AbstractWidget {
    private final GuiEventListener element;

    protected WrappedElementWidget(Minecraft client, GuiEventListener element) {
        super(client);
        this.element = element;
        if (element instanceof net.minecraft.client.gui.components.AbstractWidget) {
            net.minecraft.client.gui.components.AbstractWidget cw = (net.minecraft.client.gui.components.AbstractWidget)element;
            if (element instanceof ClickableWidgetExtension) {
                ClickableWidgetExtension ex = (ClickableWidgetExtension)element;
                ex.mpuc$setMpucHandled(true);
            }
        }
    }

    @Override
    public void render(Context context, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        if (this.element instanceof Renderable) {
            GuiEventListener guiEventListener = this.element;
            if (guiEventListener instanceof ClickableWidgetExtension) {
                ClickableWidgetExtension cw = (ClickableWidgetExtension)guiEventListener;
                cw.mpuc$setHovered(hovered);
            }
            ((Renderable)this.element).render(context.getContext(), hovered ? mouseX : -1, hovered ? mouseY : -1, tickDelta);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.element.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public int getRequestedWidth() {
        if (this.element instanceof net.minecraft.client.gui.components.AbstractWidget) {
            return ((net.minecraft.client.gui.components.AbstractWidget)this.element).getWidth();
        }
        return 10;
    }

    @Override
    public int getRequestedHeight() {
        if (this.element instanceof net.minecraft.client.gui.components.AbstractWidget) {
            return ((net.minecraft.client.gui.components.AbstractWidget)this.element).getHeight();
        }
        return 10;
    }

    public static Builder<WrappedElementWidget> builder(Minecraft client) {
        Builder<WrappedElementWidget> builder = new Builder<WrappedElementWidget>();
        builder.client = client;
        builder.consumer = a -> new WrappedElementWidget(builder.client, builder.element);
        return builder;
    }

    public static class Builder<T> {
        private Minecraft client;
        private GuiEventListener element;
        private Function<Builder<T>, T> consumer;

        private Builder() {
        }

        public Builder<T> element(GuiEventListener element) {
            this.element = element;
            return this;
        }

        public T build() {
            return this.consumer.apply(this);
        }
    }
}

