/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget.flow.widgets;

import com.jab125.mpuc.client.gui.screen.changelog.NewChangelogScreen;
import com.jab125.mpuc.client.gui.widget.flow.widgets.AbstractWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.TextWidget;
import com.jab125.mpuc.client.util.Context;
import com.jab125.mpuc.client.util.DateFormatUtil;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.util.OnlineInfo;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;

public class ChangelogVersionButtonWidget
extends AbstractWidget {
    private final int width;
    private final TextWidget textWidget;
    private final TextWidget textWidget2;
    private final OnlineInfo.Version version;
    private final ChatFormatting formatting;
    private final NewChangelogScreen screen;

    public ChangelogVersionButtonWidget(Minecraft client, NewChangelogScreen screen, OnlineInfo.Version version, int width) {
        super(client);
        this.width = width;
        this.version = version;
        boolean currentVersion = ConfigInstances.getModpackUpdateCheckerConfig().currentVersion.equals(version.id);
        DateFormatUtil.VersionStatus status = DateFormatUtil.VersionStatus.getStatus(version.releaseTime);
        this.formatting = currentVersion ? ChatFormatting.GREEN : (version.id.equals(ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().latestVersion) ? ChatFormatting.YELLOW : (status == DateFormatUtil.VersionStatus.TO_BE_ANNOUNCED ? ChatFormatting.DARK_BLUE : (status == DateFormatUtil.VersionStatus.FUTURE_RELEASE_DATE ? ChatFormatting.BLUE : ChatFormatting.GRAY)));
        this.textWidget = new TextWidget(client, (FormattedText)Component.literal((String)version.id).withStyle(this.formatting), width - 2, 20, 1.0, true);
        this.textWidget2 = new TextWidget(client, (FormattedText)DateFormatUtil.formatShort(version.releaseTime).withStyle(ChatFormatting.DARK_GRAY), width - 2, 20, 0.7, true);
        this.screen = screen;
        this.textWidget.setHeight(this.textWidget.getRequestedHeight());
        this.textWidget.setWidth(this.textWidget.getRequestedWidth());
    }

    @Override
    public void render(Context context, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        if (this.screen.getCurrentVersion() == this.version) {
            context.fill(0, 0, width, height, -16777216 + (this.formatting == ChatFormatting.GRAY ? 0xFFFFFF : this.formatting.getColor()));
            context.fill(1, 1, width - 2, height - 2, -16777216);
        }
        context.getMatrices().push();
        int f = 3;
        int tw = 3;
        context.getMatrices().translate(f, tw, 0.0);
        this.textWidget.render(context, this.textWidget.getRequestedWidth(), this.textWidget.getRequestedHeight(), mouseX - f, mouseY - tw, this.textWidget.isMouseOver(mouseX - f, mouseY - tw), tickDelta);
        context.getMatrices().pop();
        context.getMatrices().push();
        context.getMatrices().translate(f, tw += this.textWidget.getHeight(), 0.0);
        this.textWidget2.render(context, this.textWidget2.getRequestedWidth(), this.textWidget2.getRequestedHeight(), mouseX - f, mouseY - tw, this.textWidget2.isMouseOver(mouseX - f, mouseY - tw), tickDelta);
        context.getMatrices().pop();
    }

    @Override
    public int getRequestedWidth() {
        return this.width;
    }

    @Override
    public int getRequestedHeight() {
        return this.textWidget.getRequestedHeight() + this.textWidget2.getRequestedHeight() + 10;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.playDownSound(this.client.getSoundManager());
        this.screen.setCurrentVersion(this.version);
        return false;
    }

    public void playDownSound(SoundManager soundManager) {
        soundManager.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }
}

