/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget.flow.markdown;

import com.jab125.mpuc.util.ClickEventUtils;
import dev.jab125.lavendermd.Lexer;
import dev.jab125.lavendermd.MarkdownFeature;
import dev.jab125.lavendermd.Parser;
import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import net.minecraft.ChatFormatting;

public class LinkFeature
implements MarkdownFeature {
    public String name() {
        return "mpuc_links";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return true;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            nibbler.skip();
            String desc = nibbler.consumeUntil(']');
            if (desc == null || !nibbler.tryConsume('(')) {
                return false;
            }
            String url = nibbler.consumeUntil(')');
            if (url == null) {
                return false;
            }
            tokens.add(new LinkToken(desc, url));
            return true;
        }, '[');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, link, tokens) -> new LinkNode(link.url, link.description), (token, tokens) -> token instanceof LinkToken ? (LinkToken)((Object)token) : null);
    }

    private static final class LinkToken
    extends Lexer.Token {
        public final String description;
        public final String url;

        public LinkToken(String description, String url) {
            super("[" + description + "](" + url + ")");
            this.description = description;
            this.url = url;
        }
    }

    private static class LinkNode
    extends Parser.Node {
        private final String url;
        private final String description;

        public LinkNode(String url, String description) {
            this.url = url;
            this.description = description;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            compiler.visitStyle(a -> a.applyFormat(ChatFormatting.BLUE).withClickEvent(ClickEventUtils.url(this.url)));
            compiler.visitText(this.description);
            compiler.visitStyleEnd();
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

