/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget.flow.markdown;

import com.mojang.blaze3d.platform.NativeImage;
import dev.jab125.lavendermd.Lexer;
import dev.jab125.lavendermd.MarkdownFeature;
import dev.jab125.lavendermd.Parser;
import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class ImageFeature
implements MarkdownFeature {
    private static final Pattern URL_PATTERN = Pattern.compile("(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");

    public String name() {
        return "mpuc_images";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return true;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            nibbler.skip();
            if (!nibbler.tryConsume('[')) {
                return false;
            }
            String description = nibbler.consumeUntil(']');
            if (description == null || !nibbler.tryConsume('(')) {
                return false;
            }
            String url = nibbler.consumeUntil(')');
            if (url == null) {
                return false;
            }
            boolean fit = url.endsWith(",fit");
            if (fit) {
                url = url.substring(0, url.length() - 4);
            }
            if (!URL_PATTERN.matcher(url).matches()) {
                return false;
            }
            tokens.add(new ImageToken(description, url, fit));
            return true;
        }, '!');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, image, tokens) -> new ImageNode(image.url, image.description, image.fit), (token, tokens) -> token instanceof ImageToken ? (ImageToken)((Object)token) : null);
    }

    private static final class ImageToken
    extends Lexer.Token {
        public final String description;
        public final String url;
        public final boolean fit;

        public ImageToken(String description, String url, boolean fit) {
            super("![" + description + "](" + url + ")");
            this.description = description;
            this.url = url;
            this.fit = fit;
        }
    }

    private static class ImageNode
    extends Parser.Node {
        private final String url;
        private final String description;
        private final boolean fit;
        private static final Map<String, ResourceLocation> CACHED_IMAGES = new HashMap<String, ResourceLocation>();
        private static int num;

        public ImageNode(String url, String description, boolean fit) {
            this.url = url;
            this.description = description;
            this.fit = fit;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            compiler.visitImage(this.identifierFor(this.url), this.description, this.fit);
        }

        private ResourceLocation identifierFor(String url) {
            if (!CACHED_IMAGES.containsKey(url)) {
                ResourceLocation identifier;
                try {
                    identifier = ResourceLocation.fromNamespaceAndPath((String)"modpack-update-checker", (String)("generated/" + num + ".png"));
                    ImageNode.applyTexture(identifier, ImageNode.fromUrl(url));
                    ++num;
                }
                catch (Throwable t) {
                    identifier = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"missing_texture");
                }
                CACHED_IMAGES.put(url, identifier);
            }
            return CACHED_IMAGES.get(url);
        }

        private static NativeImage fromUrl(String surl) throws Throwable {
            URL url = new URL(surl);
            return NativeImage.read((InputStream)url.openStream());
        }

        private static void applyTexture(ResourceLocation identifier, NativeImage image) {
            Minecraft.getInstance().execute(() -> Minecraft.getInstance().getTextureManager().register(identifier, (AbstractTexture)new DynamicTexture(image)));
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

