/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget;

import com.jab125.mpuc.client.util.ButtonUtils;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.config.MpucConfig;
import com.jab125.mpuc.util.ClickEventUtils;
import com.jab125.mpuc.util.JavaWorkaround;
import com.jab125.mpuc.util.OnlineInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

@Deprecated
public class ScrollableTextWidget
extends AbstractSelectionList<TextEntry> {
    private static final Pattern URL_PATTERN = Pattern.compile("(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
    private final Font textRenderer;
    private final ArrayList<FormattedCharSequence> textList;
    private int bottom;

    public ScrollableTextWidget(Minecraft client, int width, int height, int top, int bottom, Component text) {
        Objects.requireNonNull(client.font);
        super(client, width, bottom - top, top, 9);
        this.textRenderer = Minecraft.getInstance().font;
        this.textList = new ArrayList();
        MpucConfig config = ConfigInstances.getModpackUpdateCheckerConfig();
        OnlineInfo info = config.getAssociatedOnlineInfo();
        if (info == null || config.currentVersion == null || info.latestVersion == null || info.versions == null || config.modpackName == null) {
            if (config.currentVersion == null) {
                this.textList.add(Component.translatable((String)"screen.modpack-update-checker.modpack-update.currentVersion-null").withStyle(ChatFormatting.RED).getVisualOrderText());
            }
            if (info == null || info.latestVersion == null) {
                this.textList.add(Component.translatable((String)"screen.modpack-update-checker.modpack-update.latestVersion-null").withStyle(ChatFormatting.RED).getVisualOrderText());
            }
            if (info == null || info.versions == null) {
                this.textList.add(Component.translatable((String)"screen.modpack-update-checker.modpack-update.changelogs-null").withStyle(ChatFormatting.RED).getVisualOrderText());
            }
            if (config.modpackName == null) {
                this.textList.add(Component.translatable((String)"screen.modpack-update-checker.modpack-update.modpackName-null").withStyle(ChatFormatting.RED).getVisualOrderText());
            }
            for (FormattedCharSequence text1 : this.textList) {
                this.addEntry(new TextEntry(text1));
            }
            return;
        }
        if (config.currentVersion.equals(info.latestVersion)) {
            this.textList.add(Component.translatable((String)"screen.modpack-update-checker.modpack-update.up-to-date").getVisualOrderText());
        } else {
            Component d = this.getChangelog();
            for (FormattedCharSequence s : this.textRenderer.split((FormattedText)d, this.getRowWidth())) {
                this.textList.add(s);
            }
        }
        for (FormattedCharSequence text1 : this.textList) {
            this.addEntry(new TextEntry(text1));
        }
        this.bottom = bottom;
    }

    public int getBottom() {
        return this.bottom;
    }

    private String getChangelogFor(String version) {
        MpucConfig config = ConfigInstances.getModpackUpdateCheckerConfig();
        OnlineInfo info = config.getAssociatedOnlineInfo();
        if (OnlineInfo.ERRORED == info) {
            return "Failed to load changelogs for " + version + ".";
        }
        if (OnlineInfo.isDisabled(info)) {
            return "Changelogs disabled.";
        }
        return info.versions.get(version).changelog().replaceAll("\r\n", "\n");
    }

    private Component getChangelog() {
        MpucConfig config = ConfigInstances.getModpackUpdateCheckerConfig();
        OnlineInfo info = config.getAssociatedOnlineInfo();
        if (OnlineInfo.ERRORED == info) {
            return Component.literal((String)"Failed to load changelogs.").withStyle(ChatFormatting.RED);
        }
        if (OnlineInfo.isDisabled(info)) {
            return Component.literal((String)"Changelogs disabled.").withStyle(ChatFormatting.RED);
        }
        List<Map.Entry> f = JavaWorkaround.Stream$toList(info.versions.entrySet().stream());
        ArrayList<String> versions = new ArrayList<String>();
        boolean started = false;
        for (Map.Entry stringJsonElementEntry : f) {
            if (!started && ((String)stringJsonElementEntry.getKey()).equals(config.currentVersion)) {
                started = true;
                continue;
            }
            if (!started) continue;
            versions.add((String)stringJsonElementEntry.getKey());
            if (!((String)stringJsonElementEntry.getKey()).equals(info.latestVersion)) continue;
            break;
        }
        MutableComponent d = Component.empty();
        for (String version : versions) {
            String fff = this.getChangelogFor(version);
            fff = URL_PATTERN.matcher(fff).replaceAll(matchResult -> "\u03c0" + matchResult.group() + "\u02c6");
            d.append((Component)Component.literal((String)(config.modpackName + " " + version + "\n\n")).withStyle(a -> a.withUnderlined(Boolean.valueOf(true))));
            d.append(this.parseUrlsAlso(fff));
            d.append("\n\n");
        }
        return d;
    }

    private Component parseUrlsAlso(String fff) {
        StringBuilder stringBuilder = new StringBuilder();
        MutableComponent text = Component.empty();
        boolean urlMode = false;
        for (char c : fff.toCharArray()) {
            if (c == '\u03c0') {
                text = text.append((Component)Component.literal((String)stringBuilder.toString()));
                stringBuilder = new StringBuilder();
                urlMode = true;
                continue;
            }
            if (c == '\u02c6') {
                String q = stringBuilder.toString();
                text = text.append((Component)Component.literal((String)q).withStyle(style -> style.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE).withClickEvent(ClickEventUtils.url(q))));
                stringBuilder = new StringBuilder();
                urlMode = false;
                continue;
            }
            stringBuilder.append(c);
        }
        text = text.append((Component)Component.literal((String)stringBuilder.toString()));
        return text;
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }

    public class TextEntry
    extends AbstractSelectionList.Entry<TextEntry> {
        private final FormattedCharSequence text;
        private int textX = -999;

        public TextEntry(FormattedCharSequence text) {
            this.text = text;
        }

        public void render(GuiGraphics drawContext, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.textX = x;
            drawContext.drawString(ScrollableTextWidget.this.textRenderer, this.text, this.textX, y, -1, true);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            double f = mouseX - (double)this.textX;
            ButtonUtils.handleBasicTextClick(((ScrollableTextWidget)ScrollableTextWidget.this).minecraft.screen, this.getTextStyleAt(f));
            return super.mouseClicked(mouseX, mouseY, button);
        }

        private Style getTextStyleAt(double x) {
            return ScrollableTextWidget.this.textRenderer.getSplitter().componentStyleAtWidth(this.text, Mth.floor((double)x));
        }
    }
}

