/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget;

import com.jab125.mpuc.client.util.ButtonUtils;
import com.jab125.mpuc.util.ChangelogUtils;
import com.jab125.mpuc.util.ClickEventUtils;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class ScrollableGenericTextWidget
extends AbstractSelectionList<TextEntry> {
    private final Font textRenderer;
    private final ArrayList<FormattedCharSequence> textList;
    private String text;
    protected int bottom;

    public ScrollableGenericTextWidget(Minecraft client, int width, int height, int top, int bottom, String text) {
        Objects.requireNonNull(client.font);
        super(client, width, bottom - top, top, 9);
        this.textRenderer = Minecraft.getInstance().font;
        this.textList = new ArrayList();
        this.setText(text);
        this.bottom = bottom;
    }

    public int getBottom() {
        return this.bottom;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.textList.clear();
        this.children().clear();
        this.text = text.replaceAll("\r\n", "\n");
        for (FormattedCharSequence s : this.textRenderer.split((FormattedText)ChangelogUtils.fromString(this.text), this.getRowWidth())) {
            this.textList.add(s);
        }
        for (FormattedCharSequence text1 : this.textList) {
            this.addEntry(new TextEntry(text1));
        }
    }

    private Component parseUrlsAlso(String fff) {
        StringBuilder stringBuilder = new StringBuilder();
        MutableComponent text = Component.empty();
        boolean urlMode = false;
        for (char c : fff.toCharArray()) {
            if (c == '\u03c0') {
                text = text.append((Component)Component.literal((String)stringBuilder.toString()));
                stringBuilder = new StringBuilder();
                urlMode = true;
                continue;
            }
            if (c == '\u02c6') {
                String q = stringBuilder.toString();
                text = text.append((Component)Component.literal((String)q).withStyle(style -> style.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE).withClickEvent(ClickEventUtils.url(q))));
                stringBuilder = new StringBuilder();
                urlMode = false;
                continue;
            }
            stringBuilder.append(c);
        }
        text = text.append((Component)Component.literal((String)stringBuilder.toString()));
        return text;
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }

    public class TextEntry
    extends AbstractSelectionList.Entry<TextEntry> {
        private final FormattedCharSequence text;
        private int textX = -999;

        public TextEntry(FormattedCharSequence text) {
            this.text = text;
        }

        public void render(GuiGraphics drawContext, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.textX = x;
            drawContext.drawString(ScrollableGenericTextWidget.this.textRenderer, this.text, this.textX, y, -1, true);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            double f = mouseX - (double)this.textX;
            Style textStyleAt = this.getTextStyleAt(f);
            if (textStyleAt != null) {
                ButtonUtils.handleBasicTextClick(Minecraft.getInstance().screen, textStyleAt);
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        private Style getTextStyleAt(double x) {
            return ScrollableGenericTextWidget.this.textRenderer.getSplitter().componentStyleAtWidth(this.text, Mth.floor((double)x));
        }
    }
}

