/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget;

import com.jab125.mpuc.client.gui.widget.flow.widgets.FlexFlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.FlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.ParentWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.Widget;
import com.jab125.mpuc.client.util.Context;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.util.FormattedCharSequence;

public class ScrollableFlowWidget
extends AbstractSelectionList<FlowEntry>
implements ParentWidget {
    private final Font textRenderer;
    private final ArrayList<FormattedCharSequence> textList;
    private FlowWidget backing;
    protected int bottom;

    public ScrollableFlowWidget(Minecraft client, int width, int height, int top, int bottom) {
        super(client, width, bottom - top, top, height);
        this.textRenderer = Minecraft.getInstance().font;
        this.textList = new ArrayList();
        this.backing = new FlexFlowWidget(client, width - 20, 0, FlowWidget.Direction.VERTICAL);
        this.bottom = bottom;
        this.addEntry(new FlowEntry(this.backing));
    }

    protected int getScrollbarPosition() {
        return this.getRowRight() - 3;
    }

    public int getRowWidth() {
        return this.width - 10;
    }

    protected int getMaxPosition() {
        return this.backing.getRequestedHeight() + this.headerHeight;
    }

    public int getBottom() {
        return this.bottom;
    }

    private int $getTop() {
        return this.getY();
    }

    private int $getBottom() {
        return this.bottom;
    }

    protected void renderListItems(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        this.itemHeight = this.backing.getRequestedHeight();
        Context context = new Context(matrices);
        context.enableScissor(this.getRowLeft(), this.$getTop(), this.getRowLeft() + this.getRowWidth(), this.bottom);
        super.renderListItems(matrices, mouseX, mouseY, delta);
        context.disableScissor();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.mouseScrolled(mouseX, mouseY, verticalAmount);
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        double d = this.getScrollAmount();
        Objects.requireNonNull(this.minecraft.font);
        this.setScrollAmount(d - amount * 9.0 / 2.0);
        return true;
    }

    @Override
    public void addChild(Widget widget) {
        this.backing.addChild(widget);
    }

    @Override
    public void addChild(int index, Widget widget) {
        this.backing.addChild(index, widget);
    }

    public void clearBacking() {
        this.remove(0);
        this.backing = new FlexFlowWidget(this.minecraft, this.width - 20, 0, FlowWidget.Direction.VERTICAL);
        this.addEntry(new FlowEntry(this.backing));
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }

    protected void renderSelection(GuiGraphics context, int y, int entryWidth, int entryHeight, int borderColor, int fillColor) {
    }

    public boolean isFocused() {
        return true;
    }

    public static class FlowEntry
    extends AbstractSelectionList.Entry<FlowEntry> {
        private final FlowWidget widget;
        private int x;
        private int y;

        public FlowEntry(FlowWidget widget) {
            this.widget = widget;
        }

        public void render(GuiGraphics matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.x = x;
            this.y = y;
            Context context = new Context(matrices);
            this.widget.setHeight(entryHeight);
            this.widget.setWidth(entryWidth);
            context.getMatrices().push();
            context.getMatrices().translate(x, y, 0.0);
            this.widget.render(context, entryWidth, entryHeight, mouseX - x, mouseY - y, hovered, tickDelta);
            context.getMatrices().pop();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return this.widget.mouseClicked(mouseX - (double)this.x, mouseY - (double)this.y, button);
        }
    }
}

