/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.screen.missingmods;

import com.jab125.mpuc.client.gui.screen.TemplateScreen;
import com.jab125.mpuc.client.gui.widget.ScrollableFlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.AbstractWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.FlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.TextWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.WrappedElementWidget;
import com.jab125.mpuc.client.util.ButtonUtils;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.config.PlatformMods;
import com.jab125.mpuc.util.Platform;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class MissingModsScreen
extends TemplateScreen {
    private final List<PlatformMods.PlatformMod> platformMods;
    private ScrollableFlowWidget flowWidget;
    private final Map<PlatformMods.PlatformMod, Context> contextMap = new HashMap<PlatformMods.PlatformMod, Context>();

    public MissingModsScreen(Component title) {
        super(title);
        this.platformMods = ConfigInstances.getPlatformMods();
    }

    protected void init() {
        double scrollAmount = this.getScrollAmount();
        super.init();
        this.flowWidget = new ScrollableFlowWidget(this.minecraft, this.width, this.height, 32, this.height - 32);
        this.addRenderableWidget((GuiEventListener)this.flowWidget);
        for (PlatformMods.PlatformMod platformMod : this.platformMods) {
            if (platformMod.presenceChecker.isPresent(platformMod)) continue;
            this.flowWidget.addChild(this.widget(platformMod));
        }
        this.flowWidget.setScrollAmount(scrollAmount);
        this.addButtonWidget(this.createButton(this.width / 2 - 100 - 49, this.height - 25, 98, 20, (Component)(Platform.getModList().stream().anyMatch(a -> a.getId().equals("modmenu")) ? Component.translatable((String)"modmenu.modsFolder") : Component.literal((String)"Open Mods Folder")), button -> Util.getPlatform().openFile(Platform.getGameDir().resolve("mods").toFile())));
        this.addButtonWidget(this.createButton(this.width / 2 + 2 - 49, this.height - 25, 98, 20, (Component)Component.translatable((String)"menu.quit"), button -> this.minecraft.stop()));
        this.addButtonWidget(this.createButton(this.width / 2 + 104 - 49, this.height - 25, 98, 20, (Component)Component.translatable((String)"screen.modpack-update-checker.missing-mods.auto-download"), button -> {
            for (Map.Entry<PlatformMods.PlatformMod, Context> entry : this.contextMap.entrySet()) {
                if (!entry.getKey().downloadLink().direct() || entry.getKey().fulfilledSource != null || !entry.getValue().button.isPresent()) continue;
                entry.getValue().pressAction.apply(entry.getKey()).onPress(entry.getValue().button.get());
            }
        }, bw -> Component.literal((String)"Download all mods possible that can be directly installed."), () -> this.contextMap.entrySet().stream().map(Map.Entry::getKey).filter(a -> a.downloadLink().direct()).anyMatch(a -> a.fulfilledSource == null)));
    }

    private void checkboxPressed() {
    }

    public void onClose() {
    }

    private AbstractWidget widget(PlatformMods.PlatformMod platformMod) {
        Context context = this.contextMap.computeIfAbsent(platformMod, a -> {
            Context context1 = new Context();
            if (platformMod.downloadLink().direct()) {
                context1.downloadButtonText = context1.downloadDirect;
            }
            boolean bl = context1.active = a.fulfilledSource == null;
            if (a.fulfilledSource != null) {
                context1.downloadButtonText = Component.translatable((String)a.fulfilledSource.getTranslationKey());
            }
            return context1;
        });
        FlowWidget widget = new FlowWidget(this.minecraft, this.width, 40, FlowWidget.Direction.HORIZONTAL);
        String string = platformMod.predicates.length == 1 ? platformMod.predicates[0] : Arrays.toString(platformMod.predicates);
        FlowWidget fWidget = new FlowWidget(this.minecraft, Math.max(this.minecraft.font.width(platformMod.displayName), this.minecraft.font.width(string)) + 3, 40, FlowWidget.Direction.VERTICAL);
        MutableComponent mutableComponent = Component.literal((String)platformMod.displayName);
        int n = this.minecraft.font.width(platformMod.displayName);
        Objects.requireNonNull(this.minecraft.font);
        fWidget.addChild(new TextWidget(this.minecraft, (FormattedText)mutableComponent, n, 9, 1.0, false));
        MutableComponent mutableComponent2 = Component.literal((String)string).withStyle(ChatFormatting.GRAY);
        int n2 = this.minecraft.font.width(string);
        Objects.requireNonNull(this.minecraft.font);
        fWidget.addChild(new TextWidget(this.minecraft, (FormattedText)mutableComponent2, n2, 9, 1.0, false));
        widget.addChild(fWidget);
        Optional<String> h = Platform.getModList().stream().filter(a -> a.getId().equals(platformMod.id)).map(Platform.Mod::getVersion).findFirst();
        String g = h.isPresent() ? "You have version " + h.get() : "You do not have this installed.";
        FlowWidget qWidget = new FlowWidget(this.minecraft, this.width - 200 - 16 - (Math.max(this.minecraft.font.width(platformMod.displayName), this.minecraft.font.width(string)) + 3), 40, FlowWidget.Direction.VERTICAL);
        MutableComponent mutableComponent3 = Component.literal((String)g).withStyle(ChatFormatting.GRAY);
        int n3 = this.minecraft.font.width(g);
        Objects.requireNonNull(this.minecraft.font);
        qWidget.addChild(new TextWidget(this.minecraft, (FormattedText)mutableComponent3, n3, 9, 1.0, true));
        widget.addChild(qWidget);
        Button button = this.createButton(0, 0, 100, 20, context.downloadButtonText, context.pressAction.apply(platformMod));
        button.active = context.active;
        context.button = Optional.of(button);
        widget.addChild(WrappedElementWidget.builder(this.minecraft).element((GuiEventListener)button).build());
        button = this.createButton(0, 0, 100, 20, (Component)Component.translatable((String)"chat.copy"), b -> this.minecraft.keyboardHandler.setClipboard(platformMod.downloadLink().link()));
        widget.addChild(WrappedElementWidget.builder(this.minecraft).element((GuiEventListener)button).build());
        return widget;
    }

    public double getScrollAmount() {
        return this.flowWidget == null ? 0.0 : this.flowWidget.getScrollAmount();
    }

    public void render(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices, mouseX, mouseY, delta);
        super.render(matrices, mouseX, mouseY, delta);
        matrices.drawCenteredString(this.font, (Component)Component.translatable((String)"screen.modpack-update-checker.missing-mods.title"), this.width / 2, 5, -1);
    }

    class Context {
        private final Component download = Component.literal((String)"Download");
        private final Component downloadDirect = Component.literal((String)"Download Direct");
        private Component downloadButtonText = this.download;
        private boolean active = true;
        private Optional<Button> button = Optional.empty();
        private Optional<Button> clipboardButton = Optional.empty();
        private Function<PlatformMods.PlatformMod, Button.OnPress> pressAction = b -> a -> {
            if (b.downloadLink().direct()) {
                boolean success = PlatformMods.downloadMod(b, PlatformMods.DownloadSource.MANUAL);
                if (success) {
                    this.active = false;
                    this.downloadButtonText = Component.translatable((String)b.fulfilledSource.getTranslationKey());
                    this.pressAction = t -> n -> {};
                    this.button.ifPresent(q -> {
                        q.active = this.active;
                        q.setMessage(this.downloadButtonText);
                    });
                } else {
                    this.downloadButtonText = Component.literal((String)"Try again");
                    a.setMessage(this.downloadButtonText);
                }
            } else {
                ButtonUtils.confirmLink(MissingModsScreen.this, false, b.downloadLink().link());
            }
        };

        Context() {
        }
    }
}

