/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.screen.changelog;

import com.jab125.mpuc.api.MpucApi;
import com.jab125.mpuc.client.gui.screen.TemplateScreen;
import com.jab125.mpuc.client.gui.screen.changelog.ChangelogScreen;
import com.jab125.mpuc.client.gui.widget.ScrollableGenericTextOverlayWidget;
import com.jab125.mpuc.client.util.Matrices;
import com.jab125.mpuc.util.OnlineInfo;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

@Deprecated
public class SpecificVersionScreen
extends TemplateScreen {
    private final ChangelogScreen parent;
    private final OnlineInfo.Version version;
    private final int lastWidth;
    private final int lastHeight;
    private final MutableComponent releaseText;
    private boolean initted;
    private boolean stop;

    public SpecificVersionScreen(ChangelogScreen parent, OnlineInfo.Version version, MutableComponent releaseText) {
        super((Component)Component.empty());
        this.parent = parent;
        this.version = version;
        this.lastWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        this.lastHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        this.releaseText = releaseText;
    }

    protected void init() {
        if (this.initted && (this.lastHeight != this.height || this.lastWidth != this.width)) {
            this.stop = true;
        }
        this.initted = true;
        super.init();
        String changelogText = this.addLinks(this.version, this.version.changelog().replaceAll("\r\n", "\n"));
        this.addRenderableWidget((GuiEventListener)new ScrollableGenericTextOverlayWidget(this.minecraft, this.width, this.height, 32, this.height - 32, changelogText));
        this.addButtonWidget(new Button(this, this.width / 2 - 51, this.height - 25, 98, 20, CommonComponents.GUI_DONE, button -> this.onClose(), Supplier::get){

            public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
                Matrices matrices = Matrices.wrap(drawContext.pose());
                matrices.push();
                matrices.translate(0.0, 0.0, 50.0);
                super.renderWidget(drawContext, mouseX, mouseY, delta);
                matrices.pop();
            }
        });
    }

    private String addLinks(OnlineInfo.Version version, String changelog) {
        OnlineInfo.Promotions promotions = version.promotions;
        if (promotions != null) {
            if (promotions.hasDownloadLinks()) {
                changelog = (String)changelog + "\n\n[Download Links]\n";
            }
            if (promotions.getDownloadLink("generic") != null) {
                changelog = (String)changelog + "Download: " + promotions.getDownloadLink("generic") + "\n";
            }
            if (promotions.getDownloadLink("curseforge") != null) {
                changelog = (String)changelog + "Curseforge: " + promotions.getDownloadLink("curseforge") + "\n";
            }
            if (promotions.getDownloadLink("modrinth") != null) {
                changelog = (String)changelog + "Modrinth: " + promotions.getDownloadLink("modrinth") + "\n";
            }
            changelog = (String)changelog + "\n";
        }
        return changelog;
    }

    public void onClose() {
        double changelogWidgetScrollAmount = this.parent.getChangelogWidgetScrollAmount();
        this.minecraft.setScreen((Screen)this.parent);
        this.parent.setChangelogWidgetScrollAmount(changelogWidgetScrollAmount);
    }

    public void render(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        super.render(matrices, mouseX, mouseY, delta);
        Matrices.wrap(matrices.pose()).push();
        Matrices.wrap(matrices.pose()).translate(0.0, 0.0, 50.0);
        matrices.drawCenteredString(this.font, MpucApi.getInstance().getModpackName() + " " + this.version.id, this.width / 2, 7, -1);
        int n = this.width / 2;
        Objects.requireNonNull(this.font);
        matrices.drawCenteredString(this.font, (Component)this.releaseText, n, 7 + 9, -1);
        Matrices.wrap(matrices.pose()).pop();
    }

    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.stop) {
            super.renderBackground(context, mouseX, mouseY, delta);
        } else {
            this.parent.render(context, mouseX, mouseY, delta);
        }
    }
}

