/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.screen.changelog;

import com.jab125.mpuc.Hotfixes;
import com.jab125.mpuc.api.MarkdownRenderer;
import com.jab125.mpuc.client.gui.screen.HotfixScreen;
import com.jab125.mpuc.client.gui.screen.TemplateScreen;
import com.jab125.mpuc.client.gui.widget.ScrollableFlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.FlowMarkdownUtils;
import com.jab125.mpuc.client.gui.widget.flow.widgets.ChangelogVersionButtonWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.FlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.InfoButtonWidget;
import com.jab125.mpuc.client.util.ButtonUtils;
import com.jab125.mpuc.client.util.Context;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.util.OnlineInfo;
import com.jab125.mpuc.util.Platform;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class NewChangelogScreen
extends TemplateScreen {
    private final Screen parent;
    private ScrollableFlowWidget changelogFlowWidget;
    private ScrollableFlowWidget versionsFlowWidget;
    private Button markdownSwitchButton;
    private MarkdownRenderer renderer;
    private final Map<String, OnlineInfo.Version> versions;
    private OnlineInfo.Version currentVersion;
    private Button modrinthButton;
    private Button downloadButton;
    private Button curseforgeButton;

    public NewChangelogScreen(Screen parent) {
        super((Component)Component.empty());
        String markdownRenderer;
        this.versions = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions;
        this.currentVersion = null;
        this.parent = parent;
        if (Platform.mpucAuthor()) {
            ConfigInstances.getModpackUpdateCheckerConfig().clearCachedText();
        }
        this.renderer = FlowMarkdownUtils.isAvailable(markdownRenderer = ConfigInstances.getModpackUpdateCheckerConfig().markdownRenderer) ? FlowMarkdownUtils.COMPILERS.get(markdownRenderer) : (FlowMarkdownUtils.isAvailable("builtin:mpuc_lavendermd") ? FlowMarkdownUtils.COMPILERS.get("builtin:mpuc_lavendermd") : MarkdownRenderer.BASIC);
    }

    protected void init() {
        double changelogScrollAmount = this.getChangelogScrollAmount();
        double versionsScrollAmount = this.getVersionsScrollAmount();
        super.init();
        int changelogPaneWidth = this.width / 3 * 2;
        int left = this.width - changelogPaneWidth;
        int right = this.width - 4;
        int width = (right - left) / 3 - 2;
        this.modrinthButton = this.createButton(left, 78, width, 20, (Component)Component.literal((String)"Modrinth"), b -> ButtonUtils.confirmLink(this, false, this.currentVersion.promotions.getDownloadLink("modrinth")));
        this.modrinthButton.active = this.currentVersion != null && this.currentVersion.promotions != null && this.currentVersion.promotions.hasDownloadLinks() && this.currentVersion.promotions.getDownloadLinkOptional("modrinth").isPresent();
        this.downloadButton = this.createButton(left + width + 2, 78, width, 20, (Component)Component.literal((String)"Generic"), b -> ButtonUtils.confirmLink(this, false, this.currentVersion.promotions.getDownloadLink("generic")));
        this.downloadButton.active = this.currentVersion != null && this.currentVersion.promotions != null && this.currentVersion.promotions.hasDownloadLinks() && this.currentVersion.promotions.getDownloadLinkOptional("generic").isPresent();
        this.curseforgeButton = this.createButton(left + width * 2 + 4, 78, width, 20, (Component)Component.literal((String)"CurseForge"), b -> ButtonUtils.confirmLink(this, false, this.currentVersion.promotions.getDownloadLink("curseforge")));
        this.curseforgeButton.active = this.currentVersion != null && this.currentVersion.promotions != null && this.currentVersion.promotions.hasDownloadLinks() && this.currentVersion.promotions.getDownloadLinkOptional("curseforge").isPresent();
        this.changelogFlowWidget = new ScrollableFlowWidget(this.minecraft, changelogPaneWidth, this.height - 70, 102, this.height - 32);
        this.addRenderableWidget((GuiEventListener)this.changelogFlowWidget);
        this.changelogFlowWidget.setX(this.width - changelogPaneWidth);
        this.addButtonWidget(this.modrinthButton);
        this.addButtonWidget(this.downloadButton);
        this.addButtonWidget(this.curseforgeButton);
        int versionsPaneWidth = this.width - changelogPaneWidth - 6;
        this.markdownSwitchButton = this.createButton(versionsPaneWidth - 34 - 6 - 20, this.height - 20 - 32, 54, 20, (Component)Component.empty(), b -> this.markdownToggled(), this::markdownButtonTooltip);
        this.setRenderer(this.renderer);
        int o = 4;
        this.versionsFlowWidget = new ScrollableFlowWidget(this.minecraft, versionsPaneWidth, this.height - 20, 32, this.height - 20 - 32 - o);
        this.addRenderableWidget((GuiEventListener)this.versionsFlowWidget);
        for (Map.Entry<String, OnlineInfo.Version> version : this.versions.entrySet()) {
            if (!ConfigInstances.getModpackUpdateCheckerConfig().tags.passes(version.getValue().tags)) continue;
            this.versionsFlowWidget.addChild(0, new ChangelogVersionButtonWidget(this.minecraft, this, version.getValue(), versionsPaneWidth));
        }
        this.versionsFlowWidget.addChild(0, new InfoButtonWidget(this.minecraft, this, versionsPaneWidth));
        this.versionsFlowWidget.addChild(FlowMarkdownUtils.process(versionsPaneWidth - 20, versionsPaneWidth - 20, 0, ""));
        this.versionsFlowWidget.addChild(new FlowWidget(this.minecraft, 0, 20, FlowWidget.Direction.VERTICAL));
        if (!Hotfixes.hotfixAvailable) {
            this.addButtonWidget(this.createButton(this.width / 2 - 100, this.height - 25, 200, 20, CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(this.parent)));
        } else {
            this.addButtonWidget(this.createButton(this.width / 2 - 100, this.height - 25, 98, 20, CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(this.parent)));
            this.addButtonWidget(this.createButton(this.width / 2 + 2, this.height - 25, 98, 20, (Component)Component.translatable((String)"screen.modpack-update-checker.hotfix.title"), button -> this.minecraft.setScreen((Screen)new HotfixScreen(this))));
        }
        this.addCredits();
        this.addButtonWidget(this.markdownSwitchButton);
        this.changelogFlowWidget.setScrollAmount(changelogScrollAmount);
        this.versionsFlowWidget.setScrollAmount(versionsScrollAmount);
    }

    private void setRenderer(MarkdownRenderer renderer) {
        this.renderer = renderer;
        this.markdownSwitchButton.setMessage((Component)Component.translatable((String)this.renderer.getDisplayNameTranslationKey()));
        this.changelogFlowWidget.clearBacking();
        this.renderChangelog();
        this.changelogFlowWidget.setScrollAmount(0.0);
    }

    private Component markdownButtonTooltip(Button widget) {
        return Component.translatable((String)this.renderer.getDescriptionTranslationKey());
    }

    private void markdownToggled() {
        List collect = FlowMarkdownUtils.COMPILERS.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        List collect1 = collect.stream().map(Map.Entry::getValue).collect(Collectors.toList());
        int rendererIndex = collect1.indexOf(this.renderer);
        int nextRendererIndex = rendererIndex + 1;
        if (nextRendererIndex >= collect1.size()) {
            nextRendererIndex = 0;
        }
        this.setRenderer((MarkdownRenderer)collect1.get(nextRendererIndex));
        this.setTooltip(this.markdownSwitchButton, this::markdownButtonTooltip);
    }

    private void renderChangelog() {
        int changelogPaneWidth = this.width / 3 * 2;
        String text = this.currentVersion != null ? this.currentVersion.changelog() : ConfigInstances.getModpackUpdateCheckerConfig().getInfoText();
        this.changelogFlowWidget.addChild(this.renderer.render(changelogPaneWidth - 20, changelogPaneWidth - 20, 0, text, ChatFormatting.GRAY));
        this.changelogFlowWidget.addChild(new FlowWidget(this.minecraft, 0, 20, FlowWidget.Direction.VERTICAL));
    }

    public OnlineInfo.Version getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(OnlineInfo.Version version) {
        if (version == this.currentVersion) {
            return;
        }
        int changelogPaneWidth = this.width / 3 * 2;
        int versionsPaneWidth = this.width - changelogPaneWidth - 5;
        this.currentVersion = version;
        this.changelogFlowWidget.clearBacking();
        this.renderChangelog();
        this.changelogFlowWidget.setScrollAmount(0.0);
        if (version != null && version.promotions != null && version.promotions.hasDownloadLinks()) {
            this.modrinthButton.active = version.promotions.getDownloadLinkOptional("modrinth").isPresent();
            this.curseforgeButton.active = version.promotions.getDownloadLinkOptional("curseforge").isPresent();
            this.downloadButton.active = version.promotions.getDownloadLinkOptional("generic").isPresent();
        } else {
            this.modrinthButton.active = false;
            this.curseforgeButton.active = false;
            this.downloadButton.active = false;
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public double getChangelogScrollAmount() {
        return this.changelogFlowWidget == null ? 0.0 : this.changelogFlowWidget.getScrollAmount();
    }

    public double getVersionsScrollAmount() {
        return this.versionsFlowWidget == null ? 0.0 : this.versionsFlowWidget.getScrollAmount();
    }

    public void render(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        super.render(matrices, mouseX, mouseY, delta);
        matrices.drawCenteredString(this.font, (Component)Component.translatable((String)"screen.modpack-update-checker.modpack-update.title"), this.width / 2, 5, -1);
        Context context = new Context(matrices);
        FormattedCharSequence formattedCharSequence = Language.getInstance().getVisualOrder((FormattedText)Component.literal((String)"Markdown").withStyle(ChatFormatting.GRAY));
        Objects.requireNonNull(this.font);
        context.drawTextWithShadow(this.font, formattedCharSequence, 9, this.height - 20 - 32 + (10 - 9 / 2), -1);
        FormattedCharSequence formattedCharSequence2 = Language.getInstance().getVisualOrder((FormattedText)Component.literal((String)ConfigInstances.getModpackUpdateCheckerConfig().modpackName));
        int n = this.width - this.width / 3 * 2;
        Objects.requireNonNull(this.font);
        Objects.requireNonNull(this.font);
        context.drawTextWithShadow(this.font, formattedCharSequence2, n, 54 - 9 - 2 - 9 - 2, -1);
        FormattedCharSequence formattedCharSequence3 = Language.getInstance().getVisualOrder((FormattedText)(this.currentVersion == null ? Component.translatable((String)"screen.modpack-update-checker.changelog.modpackInfo") : Component.literal((String)(this.currentVersion.id.startsWith("v") ? this.currentVersion.id : "v" + this.currentVersion.id))).withStyle(ChatFormatting.GRAY));
        int n2 = this.width - this.width / 3 * 2;
        Objects.requireNonNull(this.font);
        context.drawTextWithShadow(this.font, formattedCharSequence3, n2, 54 - 9 - 2, -1);
        context.drawTextWithShadow(this.font, Language.getInstance().getVisualOrder((FormattedText)Component.translatable((String)"screen.modpack-update-checker.changelog.modpackAuthors", (Object[])new Object[]{ConfigInstances.getModpackUpdateCheckerConfig().modpackAuthor}).withStyle(ChatFormatting.GRAY)), this.width - this.width / 3 * 2, 54, -1);
    }
}

